/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.equipment;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.dollar.apex.item.ModItems;
import net.dollar.apex.util.IFullSetEffectArmor;
import net.dollar.apex.util.ModItemUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import org.jetbrains.annotations.NotNull;

public class ModEndgameArmorItem
extends ArmorItem
implements IFullSetEffectArmor {
    private final BiPredicate<Holder<MobEffect>, LivingEntity> canReceiveEffectMethod;
    private final BiConsumer<List<Component>, ModItemUtils.EquipmentType> tooltipMethod;

    public ModEndgameArmorItem(ArmorMaterial material, ArmorType armorType, ModItemUtils.EndgameTier tier, Item.Properties properties) {
        super(material, armorType, properties);
        switch (tier) {
            case COBALT_STEEL: {
                this.canReceiveEffectMethod = (effect, wearer) -> {
                    boolean hasHelm = wearer.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.COBALT_STEEL_HELMET.get();
                    boolean hasChest = wearer.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.COBALT_STEEL_CHESTPLATE.get();
                    boolean hasLegs = wearer.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.COBALT_STEEL_LEGGINGS.get();
                    boolean hasBoots = wearer.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.COBALT_STEEL_BOOTS.get();
                    boolean isFullSet = hasHelm && hasChest && hasLegs && hasBoots;
                    return !isFullSet || effect != MobEffects.MOVEMENT_SLOWDOWN && effect != MobEffects.DIG_SLOWDOWN;
                };
                this.tooltipMethod = ModItemUtils::appendCobaltSteelEquipmentTooltip;
                break;
            }
            case INFUSED_GEMSTONE: {
                this.canReceiveEffectMethod = (effect, wearer) -> {
                    boolean hasHelm = wearer.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.INFUSED_GEMSTONE_HELMET.get();
                    boolean hasChest = wearer.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.INFUSED_GEMSTONE_CHESTPLATE.get();
                    boolean hasLegs = wearer.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.INFUSED_GEMSTONE_LEGGINGS.get();
                    boolean hasBoots = wearer.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.INFUSED_GEMSTONE_BOOTS.get();
                    boolean isFullSet = hasHelm && hasChest && hasLegs && hasBoots;
                    return !isFullSet || effect != MobEffects.POISON && effect != MobEffects.WITHER;
                };
                this.tooltipMethod = ModItemUtils::appendInfusedGemstoneEquipmentTooltip;
                break;
            }
            case TUNGSTEN_CARBIDE: {
                this.canReceiveEffectMethod = (effect, wearer) -> {
                    boolean hasHelm = wearer.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.TUNGSTEN_CARBIDE_HELMET.get();
                    boolean hasChest = wearer.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.TUNGSTEN_CARBIDE_CHESTPLATE.get();
                    boolean hasLegs = wearer.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.TUNGSTEN_CARBIDE_LEGGINGS.get();
                    boolean hasBoots = wearer.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.TUNGSTEN_CARBIDE_BOOTS.get();
                    boolean isFullSet = hasHelm && hasChest && hasLegs && hasBoots;
                    return !isFullSet || effect != MobEffects.WEAKNESS && effect != MobEffects.LEVITATION;
                };
                this.tooltipMethod = ModItemUtils::appendTungstenCarbideEquipmentTooltip;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tier));
            }
        }
    }

    @Override
    public boolean canReceiveEffect(Holder<MobEffect> effect, LivingEntity wearer) {
        return this.canReceiveEffectMethod.test(effect, wearer);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        this.tooltipMethod.accept(tooltip, ModItemUtils.EquipmentType.ARMOR);
    }
}

