/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.equipment;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dollar.apex.util.ModItemUtils;
import net.dollar.apex.util.ModToolTiers;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ModEndgameSwordItem
extends SwordItem {
    private final Consumer<LivingEntity> onHitMethod;
    private final BiConsumer<List<Component>, ModItemUtils.EquipmentType> tooltipMethod;

    public ModEndgameSwordItem(Tier material, int attackDamage, float attackSpeed, ModItemUtils.EndgameTier tier) {
        super(material, new Item.Properties().attributes(SwordItem.createAttributes((Tier)ModToolTiers.INFUSED_GEMSTONE, (int)attackDamage, (float)attackSpeed)).fireResistant());
        switch (tier) {
            case COBALT_STEEL: {
                this.onHitMethod = ModItemUtils::applyCobaltSteelOnHit;
                this.tooltipMethod = ModItemUtils::appendCobaltSteelEquipmentTooltip;
                break;
            }
            case INFUSED_GEMSTONE: {
                this.onHitMethod = ModItemUtils::applyInfusedGemstoneOnHit;
                this.tooltipMethod = ModItemUtils::appendInfusedGemstoneEquipmentTooltip;
                break;
            }
            case TUNGSTEN_CARBIDE: {
                this.onHitMethod = ModItemUtils::applyTungstenCarbideOnHit;
                this.tooltipMethod = ModItemUtils::appendTungstenCarbideEquipmentTooltip;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tier));
            }
        }
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        this.onHitMethod.accept(target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        this.tooltipMethod.accept(tooltip, ModItemUtils.EquipmentType.TOOL);
    }
}

