/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.ranged;

import java.util.List;
import java.util.function.BiConsumer;
import net.dollar.apex.util.ModItemUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModEndgameBowItem
extends BowItem {
    private final ModItemUtils.EndgameTier endgameTier;
    private final BiConsumer<List<Component>, ModItemUtils.EquipmentType> tooltipMethod;

    public ModEndgameBowItem(ModItemUtils.EndgameTier tier, Item.Properties properties) {
        super(properties);
        this.endgameTier = tier;
        switch (tier) {
            case COBALT_STEEL: {
                this.tooltipMethod = ModItemUtils::appendCobaltSteelEquipmentTooltip;
                break;
            }
            case INFUSED_GEMSTONE: {
                this.tooltipMethod = ModItemUtils::appendInfusedGemstoneEquipmentTooltip;
                break;
            }
            case TUNGSTEN_CARBIDE: {
                this.tooltipMethod = ModItemUtils::appendTungstenCarbideEquipmentTooltip;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tier));
            }
        }
    }

    @NotNull
    protected Projectile createProjectile(@NotNull Level level, @NotNull LivingEntity shooter, @NotNull ItemStack weaponStack, @NotNull ItemStack arrowStack, boolean crit) {
        AbstractArrow abstractarrow = ModItemUtils.createCustomArrow(level, shooter, arrowStack, weaponStack, this.endgameTier);
        if (crit) {
            abstractarrow.setCritArrow(true);
        }
        return abstractarrow;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        this.tooltipMethod.accept(tooltip, ModItemUtils.EquipmentType.RANGED);
    }
}

