/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.SmithingTemplateItem;

public class ModSmithingUpgradeItemHelper {
    private static final Component COBALT_UPGRADE = Component.literal((String)"Cobalt-Steel Upgrade").withStyle(ChatFormatting.GRAY);
    private static final Component COBALT_UPGRADE_APPLIES_TO = Component.literal((String)"Diamond Equipment").withStyle(ChatFormatting.BLUE);
    private static final Component COBALT_UPGRADE_INGREDIENTS = Component.literal((String)"Cobalt-Steel Ingot").withStyle(ChatFormatting.BLUE);
    private static final Component COBALT_UPGRADE_BASE_SLOT_DESCRIPTION = Component.literal((String)"Add diamond armor, weapon, or tool");
    private static final Component COBALT_UPGRADE_ADDITIONS_SLOT_DESCRIPTION = Component.literal((String)"Add Cobalt-Steel Ingot");
    private static final Component INFUSION_UPGRADE = Component.literal((String)"Infused Gemstone Upgrade").withStyle(ChatFormatting.GRAY);
    private static final Component INFUSION_UPGRADE_APPLIES_TO = Component.literal((String)"Diamond Equipment").withStyle(ChatFormatting.BLUE);
    private static final Component INFUSION_UPGRADE_INGREDIENTS = Component.literal((String)"Infused Gemstone").withStyle(ChatFormatting.BLUE);
    private static final Component INFUSION_UPGRADE_BASE_SLOT_DESCRIPTION = Component.literal((String)"Add diamond armor, weapon, or tool");
    private static final Component INFUSION_UPGRADE_ADDITIONS_SLOT_DESCRIPTION = Component.literal((String)"Add Infused Gemstone");
    private static final Component CARBIDE_UPGRADE = Component.literal((String)"Tungsten-Carbide Upgrade").withStyle(ChatFormatting.GRAY);
    private static final Component CARBIDE_UPGRADE_APPLIES_TO = Component.literal((String)"Diamond Equipment").withStyle(ChatFormatting.BLUE);
    private static final Component CARBIDE_UPGRADE_INGREDIENTS = Component.literal((String)"Tungsten-Carbide Ingot").withStyle(ChatFormatting.BLUE);
    private static final Component CARBIDE_UPGRADE_BASE_SLOT_DESCRIPTION = Component.literal((String)"Add diamond armor, weapon, or tool");
    private static final Component CARBIDE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION = Component.literal((String)"Add Tungsten-Carbide Ingot");
    private static final ResourceLocation EMPTY_SLOT_HELMET = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet");
    private static final ResourceLocation EMPTY_SLOT_CHESTPLATE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate");
    private static final ResourceLocation EMPTY_SLOT_LEGGINGS = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings");
    private static final ResourceLocation EMPTY_SLOT_BOOTS = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots");
    private static final ResourceLocation EMPTY_SLOT_HOE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_hoe");
    private static final ResourceLocation EMPTY_SLOT_AXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_axe");
    private static final ResourceLocation EMPTY_SLOT_SWORD = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_sword");
    private static final ResourceLocation EMPTY_SLOT_SHOVEL = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_shovel");
    private static final ResourceLocation EMPTY_SLOT_PICKAXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_pickaxe");
    private static final ResourceLocation EMPTY_SLOT_INGOT = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot");
    private static final ResourceLocation EMPTY_SLOT_DIAMOND = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_diamond");

    public static SmithingTemplateItem createCobaltUpgradeTemplate() {
        return new SmithingTemplateItem(COBALT_UPGRADE_APPLIES_TO, COBALT_UPGRADE_INGREDIENTS, COBALT_UPGRADE, COBALT_UPGRADE_BASE_SLOT_DESCRIPTION, COBALT_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, ModSmithingUpgradeItemHelper.createUpgradeIconList(), ModSmithingUpgradeItemHelper.createUpgradeMaterialList(true), new FeatureFlag[0]);
    }

    public static SmithingTemplateItem createInfusionUpgradeTemplate() {
        return new SmithingTemplateItem(INFUSION_UPGRADE_APPLIES_TO, INFUSION_UPGRADE_INGREDIENTS, INFUSION_UPGRADE, INFUSION_UPGRADE_BASE_SLOT_DESCRIPTION, INFUSION_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, ModSmithingUpgradeItemHelper.createUpgradeIconList(), ModSmithingUpgradeItemHelper.createUpgradeMaterialList(false), new FeatureFlag[0]);
    }

    public static SmithingTemplateItem createCarbideUpgradeTemplate() {
        return new SmithingTemplateItem(CARBIDE_UPGRADE_APPLIES_TO, CARBIDE_UPGRADE_INGREDIENTS, CARBIDE_UPGRADE, CARBIDE_UPGRADE_BASE_SLOT_DESCRIPTION, CARBIDE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, ModSmithingUpgradeItemHelper.createUpgradeIconList(), ModSmithingUpgradeItemHelper.createUpgradeMaterialList(true), new FeatureFlag[0]);
    }

    private static List<ResourceLocation> createUpgradeIconList() {
        return List.of(EMPTY_SLOT_HELMET, EMPTY_SLOT_SWORD, EMPTY_SLOT_CHESTPLATE, EMPTY_SLOT_PICKAXE, EMPTY_SLOT_LEGGINGS, EMPTY_SLOT_AXE, EMPTY_SLOT_BOOTS, EMPTY_SLOT_HOE, EMPTY_SLOT_SHOVEL);
    }

    private static List<ResourceLocation> createUpgradeMaterialList(boolean isIngot) {
        if (isIngot) {
            return List.of(EMPTY_SLOT_INGOT);
        }
        return List.of(EMPTY_SLOT_DIAMOND);
    }
}

