/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.block;

import java.util.function.Supplier;
import net.dollar.apex.item.ModItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"apex");
    public static final RegistryObject<Block> RUBY_BLOCK = ModBlocks.registerBlock("ruby_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_RED).setId(ModBlocks.generateBlockKey("ruby_block"))));
    public static final RegistryObject<Block> SAPPHIRE_BLOCK = ModBlocks.registerBlock("sapphire_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAPIS_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.LAPIS).setId(ModBlocks.generateBlockKey("sapphire_block"))));
    public static final RegistryObject<Block> DECORATIVE_AMETHYST_BLOCK = ModBlocks.registerBlock("decorative_amethyst_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_PURPLE).setId(ModBlocks.generateBlockKey("decorative_amethyst_block"))));
    public static final RegistryObject<Block> TIN_BLOCK = ModBlocks.registerBlock("tin_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_LIGHT_GRAY).setId(ModBlocks.generateBlockKey("tin_block"))));
    public static final RegistryObject<Block> RAW_TIN_BLOCK = ModBlocks.registerBlock("raw_tin_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK).strength(5.0f, 6.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_LIGHT_GRAY).setId(ModBlocks.generateBlockKey("raw_tin_block"))));
    public static final RegistryObject<Block> TIN_ORE = ModBlocks.registerBlock("tin_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("tin_ore"))));
    public static final RegistryObject<Block> DEEPSLATE_TIN_ORE = ModBlocks.registerBlock("deepslate_tin_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("deepslate_tin_ore"))));
    public static final RegistryObject<Block> BRONZE_BLOCK = ModBlocks.registerBlock("bronze_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.TERRACOTTA_ORANGE).setId(ModBlocks.generateBlockKey("bronze_block"))));
    public static final RegistryObject<Block> STEEL_BLOCK = ModBlocks.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("steel_block"))));
    public static final RegistryObject<Block> COBALT_BLOCK = ModBlocks.registerBlock("cobalt_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.LAPIS).setId(ModBlocks.generateBlockKey("cobalt_block"))));
    public static final RegistryObject<Block> TUNGSTEN_BLOCK = ModBlocks.registerBlock("tungsten_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("tungsten_block"))));
    public static final RegistryObject<Block> RAW_TUNGSTEN_BLOCK = ModBlocks.registerBlock("raw_tungsten_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK).strength(5.0f, 6.0f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("raw_tungsten_block"))));
    public static final RegistryObject<Block> TUNGSTEN_ORE = ModBlocks.registerBlock("tungsten_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("tungsten_ore"))));
    public static final RegistryObject<Block> DEEPSLATE_TUNGSTEN_ORE = ModBlocks.registerBlock("deepslate_tungsten_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("deepslate_tungsten_ore"))));
    public static final RegistryObject<Block> RUBY_ORE = ModBlocks.registerBlock("ruby_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("ruby_ore"))));
    public static final RegistryObject<Block> DEEPSLATE_RUBY_ORE = ModBlocks.registerBlock("deepslate_ruby_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("deepslate_ruby_ore"))));
    public static final RegistryObject<Block> SAPPHIRE_ORE = ModBlocks.registerBlock("sapphire_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("sapphire_ore"))));
    public static final RegistryObject<Block> DEEPSLATE_SAPPHIRE_ORE = ModBlocks.registerBlock("deepslate_sapphire_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("deepslate_sapphire_ore"))));
    public static final RegistryObject<Block> COBALT_ORE = ModBlocks.registerBlock("cobalt_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("cobalt_ore"))));
    public static final RegistryObject<Block> DEEPSLATE_COBALT_ORE = ModBlocks.registerBlock("deepslate_cobalt_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("deepslate_cobalt_ore"))));
    public static final RegistryObject<Block> PHOSPHATE_ORE = ModBlocks.registerBlock("phosphate_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.STONE).setId(ModBlocks.generateBlockKey("phosphate_ore"))));
    public static final RegistryObject<Block> DEEPSLATE_PHOSPHATE_ORE = ModBlocks.registerBlock("deepslate_phosphate_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).setId(ModBlocks.generateBlockKey("deepslate_phosphate_ore"))));

    private static ResourceKey<Item> generateItemKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"apex", (String)name));
    }

    private static ResourceKey<Block> generateBlockKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"apex", (String)name));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(ModBlocks.generateItemKey(name))));
    }

    public static void register(BusGroup eventBus) {
        BLOCKS.register(eventBus);
    }
}

