/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.custom;

import java.util.List;
import java.util.UUID;
import net.dollar.apex.entity.ModEntities;
import net.dollar.apex.entity.ability.ModFireballEntity;
import net.dollar.apex.entity.goal.ModMeleeAttackGoal;
import net.dollar.apex.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModObsidianGolemEntity
extends Monster
implements NeutralMob {
    private int attackAnimationTick;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int ticksSinceLastAttack = 0;
    private static final int DEFAULT_LAST_ATTACK_TICKS_THRESHOLD = 100;
    private int abilityCooldownTicks = 100;
    private static final int DEFAULT_ABILITY_COOLDOWN_TICKS = 100;

    public ModObsidianGolemEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ModMeleeAttackGoal((PathfinderMob)this, 1.0, false, 40));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static boolean checkObsidianGolemSpawnRules(EntityType<ModObsidianGolemEntity> entityType, ServerLevelAccessor accessor, EntitySpawnReason spawnReason, BlockPos blockPos, RandomSource randomSource) {
        if (accessor.getBiome(blockPos).is(Biomes.MUSHROOM_FIELDS)) {
            return false;
        }
        int y = blockPos.getY();
        if (y >= 0) {
            return false;
        }
        if (y >= -24) {
            return randomSource.nextBoolean() && ModObsidianGolemEntity.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)accessor, (EntitySpawnReason)spawnReason, (BlockPos)blockPos, (RandomSource)randomSource);
        }
        return ModObsidianGolemEntity.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)accessor, (EntitySpawnReason)spawnReason, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.ARMOR, 20.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.STEP_HEIGHT, 1.0).build();
    }

    @NotNull
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.2, 0.0, 0.2);
    }

    protected int decreaseAirSupply(int value) {
        return value;
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void addAdditionalSaveData(@NotNull ValueOutput output) {
        super.addAdditionalSaveData(output);
        this.addPersistentAngerSaveData(output);
    }

    public void readAdditionalSaveData(@NotNull ValueInput input) {
        super.readAdditionalSaveData(input);
        this.readPersistentAngerSaveData(this.level(), input);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int value) {
        this.remainingPersistentAngerTime = value;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(@javax.annotation.Nullable UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return switch (this.getRandom().nextInt(3)) {
            case 0 -> SoundEvents.RAVAGER_AMBIENT;
            case 1 -> SoundEvents.CREAKING_AMBIENT;
            case 2 -> SoundEvents.CREAKING_TWITCH;
            default -> null;
        };
    }

    public int getAmbientSoundInterval() {
        return 300;
    }

    protected void playStepSound(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP);
    }

    protected void playAttackSound() {
        this.playSound(SoundEvents.IRON_GOLEM_ATTACK);
    }

    public boolean doHurtTarget(@NotNull ServerLevel serverLevel, @NotNull Entity targetEntity) {
        this.ticksSinceLastAttack = 0;
        this.attackAnimationTick = 10;
        if (super.doHurtTarget(serverLevel, targetEntity)) {
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)targetEntity;
                if (this.random.nextFloat() > this.getHealth() / this.getMaxHealth() - 0.25f) {
                    livingEntity.igniteForSeconds(4.0f);
                }
            }
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, this.getSoundVolume(), 1.0f);
            return true;
        }
        return false;
    }

    public boolean hurtServer(@NotNull ServerLevel serverLevel, @NotNull DamageSource source, float value) {
        Crackiness.Level irongolem$crackiness = this.getCrackiness();
        boolean flag = super.hurtServer(serverLevel, source, value);
        if (flag && this.getCrackiness() != irongolem$crackiness) {
            this.playSound(SoundEvents.IRON_GOLEM_DAMAGE, this.getSoundVolume(), 1.0f);
        }
        return flag;
    }

    public Crackiness.Level getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean checkSpawnObstruction(LevelReader levelReader) {
        BlockPos blockpos = this.blockPosition();
        BlockPos blockpos1 = blockpos.below();
        BlockState blockstate = levelReader.getBlockState(blockpos1);
        if (!blockstate.entityCanStandOn((BlockGetter)levelReader, blockpos1, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstate1;
            BlockPos blockpos2 = blockpos.above(i);
            if (NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)levelReader, (BlockPos)blockpos2, (BlockState)(blockstate1 = levelReader.getBlockState(blockpos2)), (FluidState)blockstate1.getFluidState(), (EntityType)((EntityType)ModEntities.OBSIDIAN_GOLEM.get()))) continue;
            return false;
        }
        return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)levelReader, (BlockPos)blockpos, (BlockState)levelReader.getBlockState(blockpos), (FluidState)Fluids.EMPTY.defaultFluidState(), (EntityType)((EntityType)ModEntities.OBSIDIAN_GOLEM.get())) && levelReader.isUnobstructed((Entity)this);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.getTarget() == null) {
            this.ticksSinceLastAttack = 0;
            return;
        }
        ++this.ticksSinceLastAttack;
        --this.abilityCooldownTicks;
        if (this.ticksSinceLastAttack >= 100 && this.abilityCooldownTicks <= 0 && this.random.nextInt(100) == 0) {
            this.rangedAttackNearbyPlayers(serverLevel);
            this.abilityCooldownTicks = 100;
        }
    }

    private void rangedAttackNearbyPlayers(ServerLevel serverLevel) {
        double radius = 24.0;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        List players = this.level().getEntitiesOfClass(Player.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        this.playSound(SoundEvents.RAVAGER_ROAR, this.getSoundVolume(), 1.0f);
        for (Player player : players) {
            player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 60, 2, false, false, true));
            this.shootFireballAtPlayer(player);
            if (this.getSensing().hasLineOfSight((Entity)player)) continue;
            player.hurtServer(serverLevel, this.damageSources().mobAttack((LivingEntity)this), 5.0f);
            player.igniteForSeconds(4.0f);
        }
    }

    private void shootFireballAtPlayer(Player player) {
        double xDist = player.getX() - this.getX();
        double yDist = player.getY(0.5) - this.getY(0.5);
        double zDist = player.getZ() - this.getZ();
        Vec3 vec3 = new Vec3(xDist, yDist, zDist);
        ModFireballEntity modFireballEntity = new ModFireballEntity(this.level(), (LivingEntity)this, vec3.normalize());
        modFireballEntity.setPos(modFireballEntity.getX(), this.getY(0.5) + 0.5, modFireballEntity.getZ());
        this.level().addFreshEntity((Entity)modFireballEntity);
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        Holder mobEffect = effectInstance.getEffect();
        return mobEffect != MobEffects.POISON && mobEffect != MobEffects.HUNGER;
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource source, boolean killedByPlayer) {
        ItemEntity trophyItem;
        Player player;
        ItemStack heldItem;
        if (!killedByPlayer) {
            return;
        }
        ItemEntity itementity = this.spawnAtLocation(level, (ItemLike)ModItems.MOLTEN_CORE.get());
        if (itementity != null) {
            itementity.setExtendedLifetime();
        }
        Registry registryLookup = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Entity entity = source.getEntity();
        if (entity instanceof Player && (heldItem = (player = (Player)entity).getItemBySlot(EquipmentSlot.MAINHAND)).getItem() == ModItems.TUNGSTEN_CARBIDE_BATTLEAXE.get() && EnchantmentHelper.getItemEnchantmentLevel((Holder)registryLookup.getOrThrow(Enchantments.SHARPNESS), (ItemStack)heldItem) >= 5 && (trophyItem = this.spawnAtLocation(level, (ItemLike)ModItems.TROPHY_OBSIDIAN_DUST.get())) != null) {
            trophyItem.setExtendedLifetime();
        }
    }

    public int getBaseExperienceReward(@NotNull ServerLevel serverLevel) {
        return 50;
    }

    public int getMaxFallDistance() {
        return 10;
    }

    public boolean fireImmune() {
        return true;
    }
}

