/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.ability;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ModFireballEntity
extends SmallFireball {
    public ModFireballEntity(Level level, LivingEntity owner, Vec3 velocity) {
        super(level, owner, velocity.x, velocity.y, velocity.z);
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            Entity hitEntity = entityHitResult.getEntity();
            Entity ownerEntity = this.getOwner();
            int fireTicks = hitEntity.getRemainingFireTicks();
            hitEntity.igniteForSeconds(4);
            DamageSource damageSource = this.damageSources().fireball((Fireball)this, ownerEntity);
            if (!hitEntity.hurt(damageSource, 5.0f)) {
                hitEntity.setRemainingFireTicks(fireTicks);
            } else if (ownerEntity instanceof LivingEntity) {
                LivingEntity ownerLivingEntity = (LivingEntity)ownerEntity;
                this.doEnchantDamageEffects(ownerLivingEntity, hitEntity);
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
    }
}

