/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.ranged;

import java.util.function.Consumer;
import net.dollar.apex.util.ModItemUtils;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ModCustomArrowEntity
extends Arrow {
    private boolean isSpectral;
    private final Consumer<LivingEntity> onHitMethod;

    public ModCustomArrowEntity(Level level, LivingEntity owner, ItemStack arrowStack, ModItemUtils.EndgameTier tier) {
        super(level, owner, arrowStack);
        this.setBaseDamage(3.0);
        switch (tier) {
            case COBALT_STEEL: {
                this.onHitMethod = ModItemUtils::applyCobaltSteelOnHit;
                break;
            }
            case INFUSED_GEMSTONE: {
                this.onHitMethod = ModItemUtils::applyInfusedGemstoneOnHit;
                break;
            }
            case TUNGSTEN_CARBIDE: {
                this.onHitMethod = ModItemUtils::applyTungstenCarbideOnHit;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tier));
            }
        }
    }

    public void checkIsSpectral(ItemStack arrow) {
        if (arrow.getItem() instanceof SpectralArrowItem) {
            this.isSpectral = true;
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        Entity entity = hitResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (this.isSpectral) {
                MobEffectInstance statusEffectInstance = new MobEffectInstance(MobEffects.GLOWING, 200, 0);
                target.addEffect(statusEffectInstance, this.getOwner());
            }
            this.onHitMethod.accept(target);
        }
    }
}

