/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.util;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dollar.apex.item.custom.ranged.ModCustomArrowEntity;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ModItemUtils {
    public static final Set<ToolAction> DEFAULT_PAXEL_ACTIONS = Stream.of(ToolActions.AXE_DIG, ToolActions.HOE_DIG, ToolActions.PICKAXE_DIG, ToolActions.SHOVEL_DIG).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public static AbstractArrow createCustomArrow(Level level, LivingEntity shooter, ItemStack arrowStack, EndgameTier tier) {
        ModCustomArrowEntity arrowEntity = new ModCustomArrowEntity(level, shooter, arrowStack, tier);
        arrowEntity.checkIsSpectral(arrowStack);
        return arrowEntity;
    }

    public static void applyCobaltSteelOnHit(LivingEntity target) {
        Player player;
        if (target instanceof Player && (player = (Player)target).isCreative()) {
            return;
        }
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 1));
    }

    public static void appendCobaltSteelEquipmentTooltip(List<Component> tooltip, EquipmentType equipmentType) {
        if (Screen.hasShiftDown()) {
            switch (equipmentType.ordinal()) {
                case 0: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_armor_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_armor_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_armor_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_armor_full_set"));
                    break;
                }
                case 1: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_tool_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_tool_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_tool_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_tool_details_3"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_tool_details_4"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_on_hit_effect"));
                    break;
                }
                case 2: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_ranged_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_ranged_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_ranged_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_ranged_bonus_damage"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_on_hit_effect"));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobalt_steel_hold_shift"));
        }
    }

    public static void applyInfusedGemstoneOnHit(LivingEntity target) {
        Player player;
        if (target instanceof Player && (player = (Player)target).isCreative()) {
            return;
        }
        target.addEffect(new MobEffectInstance(MobEffects.WITHER, 81, 1));
    }

    public static void appendInfusedGemstoneEquipmentTooltip(List<Component> tooltip, EquipmentType equipmentType) {
        if (Screen.hasShiftDown()) {
            switch (equipmentType.ordinal()) {
                case 0: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_armor_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_armor_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_armor_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_armor_full_set"));
                    break;
                }
                case 1: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_tool_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_tool_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_tool_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_tool_details_3"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_tool_details_4"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_on_hit_effect"));
                    break;
                }
                case 2: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_ranged_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_ranged_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_ranged_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_ranged_details_3"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_ranged_bonus_damage"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_on_hit_effect"));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.infused_gemstone_hold_shift"));
        }
    }

    public static void applyTungstenCarbideOnHit(LivingEntity target) {
        Player player;
        if (target instanceof Player && (player = (Player)target).isCreative()) {
            return;
        }
        target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0));
    }

    public static void appendTungstenCarbideEquipmentTooltip(List<Component> tooltip, EquipmentType equipmentType) {
        if (Screen.hasShiftDown()) {
            switch (equipmentType.ordinal()) {
                case 0: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_armor_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_armor_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_armor_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_armor_full_set"));
                    break;
                }
                case 1: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_tool_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_tool_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_tool_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_tool_details_3"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_tool_details_4"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_on_hit_effect"));
                    break;
                }
                case 2: {
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_ranged_details_0"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_ranged_details_1"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_ranged_details_2"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_ranged_details_3"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_ranged_bonus_damage"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_on_hit_effect"));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.tungsten_carbide_hold_shift"));
        }
    }

    public static enum EndgameTier {
        COBALT_STEEL,
        INFUSED_GEMSTONE,
        TUNGSTEN_CARBIDE;

    }

    public static enum EquipmentType {
        ARMOR,
        TOOL,
        RANGED;

    }
}

