/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;

public class ModLootUtils {
    public static final ResourceLocation VILLAGE_ARMORER_ID = new ResourceLocation("chests/village/village_armorer");
    public static final ResourceLocation VILLAGE_MASON_ID = new ResourceLocation("chests/village/village_mason");
    public static final ResourceLocation VILLAGE_TOOLSMITH_ID = new ResourceLocation("chests/village/village_toolsmith");
    public static final ResourceLocation VILLAGE_WEAPONSMITH_ID = new ResourceLocation("chests/village/village_weaponsmith");
    public static final ResourceLocation IGLOO_CHEST_ID = new ResourceLocation("chests/igloo_chest");
    public static final ResourceLocation SHIPWRECK_SUPPLY_ID = new ResourceLocation("chests/shipwreck_supply");
    public static final ResourceLocation ABANDONED_MINESHAFT_ID = new ResourceLocation("chests/abandoned_mineshaft");
    public static final ResourceLocation BURIED_TREASURE_ID = new ResourceLocation("chests/buried_treasure");
    public static final ResourceLocation DESERT_PYRAMID_ID = new ResourceLocation("chests/desert_pyramid");
    public static final ResourceLocation JUNGLE_TEMPLE_ID = new ResourceLocation("chests/jungle_temple");
    public static final ResourceLocation NETHER_BRIDGE_ID = new ResourceLocation("chests/nether_bridge");
    public static final ResourceLocation PILLAGER_OUTPOST_ID = new ResourceLocation("chests/pillager_outpost");
    public static final ResourceLocation RUINED_PORTAL_ID = new ResourceLocation("chests/ruined_portal");
    public static final ResourceLocation SHIPWRECK_TREASURE_ID = new ResourceLocation("chests/shipwreck_treasure");
    public static final ResourceLocation SIMPLE_DUNGEON_ID = new ResourceLocation("chests/simple_dungeon");
    public static final ResourceLocation UNDERWATER_RUIN_BIG_ID = new ResourceLocation("chests/underwater_ruin_big");
    public static final ResourceLocation UNDERWATER_RUIN_SMALL_ID = new ResourceLocation("chests/underwater_ruin_small");
    public static final ResourceLocation ANCIENT_CITY_ID = new ResourceLocation("chests/ancient_city");
    public static final ResourceLocation ANCIENT_CITY_ICE_BOX_ID = new ResourceLocation("chests/ancient_city_ice_box");
    public static final ResourceLocation BASTION_BRIDGE_ID = new ResourceLocation("chests/bastion_bridge");
    public static final ResourceLocation BASTION_HOGLIN_STABLE_ID = new ResourceLocation("chests/bastion_hoglin_stable");
    public static final ResourceLocation BASTION_OTHER_ID = new ResourceLocation("chests/bastion_other");
    public static final ResourceLocation BASTION_TREASURE_ID = new ResourceLocation("chests/bastion_treasure");
    public static final ResourceLocation END_CITY_TREASURE_ID = new ResourceLocation("chests/end_city_treasure");
    public static final ResourceLocation STRONGHOLD_CORRIDOR_ID = new ResourceLocation("chests/stronghold_corridor");
    public static final ResourceLocation STRONGHOLD_CROSSING_ID = new ResourceLocation("chests/stronghold_crossing");
    public static final ResourceLocation STRONGHOLD_LIBRARY_ID = new ResourceLocation("chests/stronghold_library");
    public static final ResourceLocation WOODLAND_MANSION_ID = new ResourceLocation("chests/woodland_mansion");

    public static void genLootByRarity(ObjectArrayList<ItemStack> generatedLoot, LootContext context, Item item, int rolls, Loot_Rarity rarity, Loot_Type type) {
        float chanceRatio = 1.0f;
        switch (type.ordinal()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                chanceRatio = 0.33f;
                break;
            }
            case 3: {
                chanceRatio = 0.2f;
            }
        }
        switch (rarity.ordinal()) {
            case 0: {
                for (int i = 0; i < rolls; ++i) {
                    if (!(context.getRandom().nextFloat() < 0.4f * chanceRatio)) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)item, 1));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < rolls; ++i) {
                    if (!(context.getRandom().nextFloat() < 0.3f * chanceRatio)) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)item, 1));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < rolls; ++i) {
                    if (!(context.getRandom().nextFloat() < 0.2f * chanceRatio)) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)item, 1));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < rolls; ++i) {
                    if (!(context.getRandom().nextFloat() < 0.1f * chanceRatio)) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)item, 1));
                }
                break;
            }
        }
    }

    public static enum Loot_Type {
        BASIC_UPGRADE,
        FINISHED_UPGRADE,
        BASIC_INGREDIENT,
        UPGRADE_INGREDIENT;

    }

    public static enum Loot_Rarity {
        COMMON,
        UNCOMMON,
        RARE,
        VERY_RARE;

    }
}

