/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.worldgen;

import java.util.List;
import net.dollar.apex.worldgen.ModConfiguredFeatures;
import net.dollar.apex.worldgen.ModOrePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> RUBY_ORE_PLACED_KEY = ModPlacedFeatures.createKey("ruby_ore_placed");
    public static final ResourceKey<PlacedFeature> SAPPHIRE_ORE_PLACED_KEY = ModPlacedFeatures.createKey("sapphire_ore_placed");
    public static final ResourceKey<PlacedFeature> COBALT_ORE_PLACED_KEY = ModPlacedFeatures.createKey("cobalt_ore_placed");
    public static final ResourceKey<PlacedFeature> PHOSPHATE_ORE_PLACED_KEY = ModPlacedFeatures.createKey("phosphate_ore_placed");
    public static final ResourceKey<PlacedFeature> TIN_ORE_PLACED_KEY = ModPlacedFeatures.createKey("tin_ore_placed");
    public static final ResourceKey<PlacedFeature> TIN_ORE_SMALL_PLACED_KEY = ModPlacedFeatures.createKey("tin_ore_small_placed");
    public static final ResourceKey<PlacedFeature> TUNGSTEN_ORE_PLACED_KEY = ModPlacedFeatures.createKey("tungsten_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, RUBY_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.RUBY_ORE_KEY), ModOrePlacement.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, SAPPHIRE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.SAPPHIRE_ORE_KEY), ModOrePlacement.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, COBALT_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.COBALT_ORE_KEY), ModOrePlacement.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-48), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        ModPlacedFeatures.register(context, PHOSPHATE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.PHOSPHATE_ORE_KEY), ModOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, TIN_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.TIN_ORE_KEY), ModOrePlacement.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)112))));
        ModPlacedFeatures.register(context, TIN_ORE_SMALL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.TIN_ORE_SMALL_KEY), ModOrePlacement.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        ModPlacedFeatures.register(context, TUNGSTEN_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.TUNGSTEN_ORE_KEY), ModOrePlacement.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-48), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("apex", name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        ModPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

