/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.ability;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ModFireballEntity
extends SmallFireball {
    public ModFireballEntity(Level level, LivingEntity owner, Vec3 velocity) {
        super(level, owner, velocity);
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity hitEntity = entityHitResult.getEntity();
            Entity ownerEntity = this.getOwner();
            int fireTicks = hitEntity.getRemainingFireTicks();
            hitEntity.igniteForSeconds(4.0f);
            DamageSource damageSource = this.damageSources().fireball((Fireball)this, ownerEntity);
            if (!hitEntity.hurtServer(serverlevel, damageSource, 5.0f)) {
                hitEntity.setRemainingFireTicks(fireTicks);
            } else {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)hitEntity, (DamageSource)damageSource);
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
    }
}

