/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.custom;

import java.util.List;
import java.util.UUID;
import net.dollar.apex.entity.goal.ModMeleeAttackGoal;
import net.dollar.apex.entity.goal.ModStareOrMoveGoal;
import net.dollar.apex.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModMysteriousSpecterEntity
extends Monster
implements NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int ticksSinceLastAttack = 0;
    private static final int DEFAULT_LAST_ATTACK_TICKS_THRESHOLD = 100;
    private int auraCounterTicks = 60;
    private int abilityCooldownTicks = 100;
    private static final int DEFAULT_ABILITY_COOLDOWN_TICKS = 100;

    public ModMysteriousSpecterEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ModMeleeAttackGoal((PathfinderMob)this, 1.0, false, 40));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new ModStareOrMoveGoal((PathfinderMob)this, Player.class, 10.0f, 0.666, 0.001f));
    }

    public static boolean checkMysteriousSpecterSpawnRules(EntityType<ModMysteriousSpecterEntity> entityType, ServerLevelAccessor accessor, EntitySpawnReason spawnReason, BlockPos blockPos, RandomSource randomSource) {
        if (accessor.getBiome(blockPos).is(Biomes.MUSHROOM_FIELDS)) {
            return false;
        }
        if (blockPos.getY() < 62) {
            return false;
        }
        return ModMysteriousSpecterEntity.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)accessor, (EntitySpawnReason)spawnReason, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.STEP_HEIGHT, 1.0).build();
    }

    @NotNull
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.1, 0.0, 0.1);
    }

    protected int decreaseAirSupply(int value) {
        return value;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag p_28867_) {
        super.addAdditionalSaveData(p_28867_);
        this.addPersistentAngerSaveData(p_28867_);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag p_28857_) {
        super.readAdditionalSaveData(p_28857_);
        this.readPersistentAngerSaveData(this.level(), p_28857_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int value) {
        this.remainingPersistentAngerTime = value;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(@javax.annotation.Nullable UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return SoundEvents.BLAZE_AMBIENT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return SoundEvents.BLAZE_DEATH;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return switch (this.getRandom().nextInt(5)) {
            case 0 -> SoundEvents.BLAZE_AMBIENT;
            case 1 -> SoundEvents.HUSK_AMBIENT;
            case 2 -> SoundEvents.ZOMBIE_VILLAGER_AMBIENT;
            case 3 -> SoundEvents.GHAST_AMBIENT;
            case 4 -> SoundEvents.WARDEN_TENDRIL_CLICKS;
            default -> null;
        };
    }

    public int getAmbientSoundInterval() {
        return 300;
    }

    protected float getSoundVolume() {
        return 0.666f;
    }

    protected void playAttackSound() {
        this.playSound(SoundEvents.RAVAGER_ATTACK);
    }

    public boolean doHurtTarget(@NotNull ServerLevel serverLevel, @NotNull Entity targetEntity) {
        this.ticksSinceLastAttack = 0;
        if (super.doHurtTarget(serverLevel, targetEntity)) {
            this.resetMovementSpeed();
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)targetEntity;
                if (this.random.nextBoolean()) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 81, this.calcWitherStrength(), false, false, true));
                }
            }
            this.setHealth(this.getHealth() + 2.0f);
            this.playSound(SoundEvents.RAVAGER_ATTACK, this.getSoundVolume(), 1.0f);
            return true;
        }
        return false;
    }

    private int calcWitherStrength() {
        double strength = 1.0 - (double)(this.getHealth() / this.getMaxHealth());
        strength *= 3.0;
        strength = Math.floor(strength);
        return (int)strength;
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        --this.auraCounterTicks;
        if (this.auraCounterTicks <= 0) {
            this.applyWeaknessHungerAura();
            this.auraCounterTicks = 60;
        }
        if (this.getTarget() == null) {
            this.ticksSinceLastAttack = 0;
            return;
        }
        ++this.ticksSinceLastAttack;
        --this.abilityCooldownTicks;
        if (this.ticksSinceLastAttack > 100 && this.abilityCooldownTicks <= 0 && this.random.nextInt(100) == 0) {
            this.blindAndSlowNearbyPlayers();
            this.increaseMovementSpeedTemporarily();
            if (this.ticksSinceLastAttack >= 150) {
                this.witherAndDamageNearbyPlayers(serverLevel);
            }
            this.abilityCooldownTicks = 100;
        }
    }

    private void applyWeaknessHungerAura() {
        double radius = 10.0;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        List players = this.level().getEntitiesOfClass(Player.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        for (Player player : players) {
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 0, false, false, true));
            player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 200, 0, false, false, true));
        }
    }

    private void blindAndSlowNearbyPlayers() {
        double radius = 24.0;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        List players = this.level().getEntitiesOfClass(Player.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        switch (this.random.nextInt(3)) {
            case 0: {
                this.playSound(SoundEvents.ENDERMAN_SCREAM, this.getSoundVolume(), 1.0f);
                break;
            }
            case 1: {
                this.playSound(SoundEvents.WARDEN_ANGRY, this.getSoundVolume(), 1.0f);
                break;
            }
            default: {
                this.playSound(SoundEvents.RAVAGER_ROAR, this.getSoundVolume(), 1.0f);
            }
        }
        for (Player player : players) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1, false, false, true));
            player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 0, false, false, true));
        }
    }

    private void witherAndDamageNearbyPlayers(ServerLevel serverLevel) {
        double radius = 24.0;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        List players = this.level().getEntitiesOfClass(Player.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        int intensity = this.calcWitherStrength();
        for (Player player : players) {
            player.addEffect(new MobEffectInstance(MobEffects.WITHER, 81, intensity, false, false, true));
            player.hurtServer(serverLevel, this.damageSources().mobAttack((LivingEntity)this), 5.0f);
        }
    }

    private void increaseMovementSpeedTemporarily() {
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 2, false, false));
        this.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
    }

    private void resetMovementSpeed() {
        if (this.hasEffect(MobEffects.MOVEMENT_SPEED)) {
            this.removeEffect(MobEffects.MOVEMENT_SPEED);
        }
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        Holder mobEffect = effectInstance.getEffect();
        return mobEffect != MobEffects.POISON && mobEffect != MobEffects.WITHER && mobEffect != MobEffects.HUNGER;
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel serverLevel, @NotNull DamageSource source, boolean killedByPlayer) {
        ItemEntity trophyItem;
        Player player;
        Item heldItem;
        Entity entity;
        if (!killedByPlayer) {
            return;
        }
        ItemEntity itementity = this.spawnAtLocation(serverLevel, (ItemLike)ModItems.HANDFUL_OF_STARDUST.get());
        if (itementity != null) {
            itementity.setExtendedLifetime();
        }
        if ((entity = source.getEntity()) instanceof Player && ((heldItem = (player = (Player)entity).getItemBySlot(EquipmentSlot.MAINHAND).getItem()) == Items.NETHERITE_HOE || heldItem == ModItems.COBALT_STEEL_HOE.get() || heldItem == ModItems.INFUSED_GEMSTONE_HOE.get() || heldItem == ModItems.TUNGSTEN_CARBIDE_HOE.get()) && (trophyItem = this.spawnAtLocation(serverLevel, (ItemLike)ModItems.TROPHY_OMINOUS_LETTER.get())) != null) {
            trophyItem.setExtendedLifetime();
        }
    }

    public int getBaseExperienceReward(@NotNull ServerLevel serverLevel) {
        return 50;
    }

    public int getMaxFallDistance() {
        return 10;
    }

    public boolean fireImmune() {
        return true;
    }
}

