/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.equipment;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dollar.apex.util.ModItemUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ModEndgameAxeItem
extends AxeItem {
    private final Consumer<LivingEntity> onHitMethod;
    private final BiConsumer<List<Component>, ModItemUtils.EquipmentType> tooltipMethod;

    public ModEndgameAxeItem(ToolMaterial material, float attackDamage, float attackSpeed, ModItemUtils.EndgameTier tier, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
        switch (tier) {
            case COBALT_STEEL: {
                this.onHitMethod = ModItemUtils::applyCobaltSteelOnHit;
                this.tooltipMethod = ModItemUtils::appendCobaltSteelEquipmentTooltip;
                break;
            }
            case INFUSED_GEMSTONE: {
                this.onHitMethod = ModItemUtils::applyInfusedGemstoneOnHit;
                this.tooltipMethod = ModItemUtils::appendInfusedGemstoneEquipmentTooltip;
                break;
            }
            case TUNGSTEN_CARBIDE: {
                this.onHitMethod = ModItemUtils::applyTungstenCarbideOnHit;
                this.tooltipMethod = ModItemUtils::appendTungstenCarbideEquipmentTooltip;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tier));
            }
        }
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        this.onHitMethod.accept(target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        this.tooltipMethod.accept(tooltip, ModItemUtils.EquipmentType.TOOL);
    }
}

