/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.loot.chest;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.dollar.apex.util.ModLootUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModSteelIngotLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<ModSteelIngotLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ModSteelIngotLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).apply((Applicative)inst, ModSteelIngotLootModifier::new)));
    final Item item;

    protected ModSteelIngotLootModifier(LootItemCondition[] conditionsIn, Item item) {
        super(conditionsIn);
        this.item = item;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(LootTable lootTable, ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation chest = context.getQueriedLootTableId();
        if (chest.equals((Object)ModLootUtils.ABANDONED_MINESHAFT_ID) || chest.equals((Object)ModLootUtils.PILLAGER_OUTPOST_ID)) {
            ModLootUtils.genLootByRarity(generatedLoot, context, this.item, 2, ModLootUtils.Loot_Rarity.COMMON, ModLootUtils.Loot_Type.UPGRADE_INGREDIENT);
        }
        if (chest.equals((Object)ModLootUtils.BURIED_TREASURE_ID) || chest.equals((Object)ModLootUtils.JUNGLE_TEMPLE_ID) || chest.equals((Object)ModLootUtils.RUINED_PORTAL_ID) || chest.equals((Object)ModLootUtils.SHIPWRECK_TREASURE_ID) || chest.equals((Object)ModLootUtils.SIMPLE_DUNGEON_ID) || chest.equals((Object)ModLootUtils.STRONGHOLD_CORRIDOR_ID) || chest.equals((Object)ModLootUtils.STRONGHOLD_CROSSING_ID) || chest.equals((Object)ModLootUtils.STRONGHOLD_LIBRARY_ID) || chest.equals((Object)ModLootUtils.UNDERWATER_RUIN_BIG_ID) || chest.equals((Object)ModLootUtils.UNDERWATER_RUIN_SMALL_ID) || chest.equals((Object)ModLootUtils.WOODLAND_MANSION_ID)) {
            ModLootUtils.genLootByRarity(generatedLoot, context, this.item, 2, ModLootUtils.Loot_Rarity.UNCOMMON, ModLootUtils.Loot_Type.UPGRADE_INGREDIENT);
        }
        if (chest.equals((Object)ModLootUtils.ANCIENT_CITY_ID) || chest.equals((Object)ModLootUtils.DESERT_PYRAMID_ID) || chest.equals((Object)ModLootUtils.END_CITY_TREASURE_ID) || chest.equals((Object)ModLootUtils.IGLOO_CHEST_ID) || chest.equals((Object)ModLootUtils.VILLAGE_ARMORER_ID) || chest.equals((Object)ModLootUtils.VILLAGE_TOOLSMITH_ID) || chest.equals((Object)ModLootUtils.VILLAGE_WEAPONSMITH_ID)) {
            ModLootUtils.genLootByRarity(generatedLoot, context, this.item, 2, ModLootUtils.Loot_Rarity.RARE, ModLootUtils.Loot_Type.UPGRADE_INGREDIENT);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

