/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.datagen;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.dollar.apex.datagen.ModBlockModelGenerators;
import net.dollar.apex.datagen.ModItemModelGenerators;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModModelProvider
extends ModelProvider {
    public ModModelProvider(PackOutput output) {
        super(output);
    }

    @NotNull
    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> "apex".equals(item.builtInRegistryHolder().key().location().getNamespace()));
    }

    @NotNull
    protected Stream<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> "apex".equals(block.builtInRegistryHolder().key().location().getNamespace()));
    }

    @NotNull
    protected ItemModelGenerators getItemModelGenerators(@NotNull ModelProvider.ItemInfoCollector items, @NotNull ModelProvider.SimpleModelCollector models) {
        return new ModItemModelGenerators((ItemModelOutput)items, (BiConsumer<ResourceLocation, ModelInstance>)models);
    }

    @NotNull
    protected BlockModelGenerators getBlockModelGenerators(@NotNull ModelProvider.BlockStateGeneratorCollector blocks, @NotNull ModelProvider.ItemInfoCollector items, @NotNull ModelProvider.SimpleModelCollector models) {
        return new ModBlockModelGenerators((Consumer<BlockModelDefinitionGenerator>)blocks, (ItemModelOutput)items, (BiConsumer<ResourceLocation, ModelInstance>)models);
    }
}

