/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.ranged;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dollar.apex.util.ModItemUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModEndgameCrossbowItem
extends CrossbowItem {
    private final ModItemUtils.EndgameTier endgameTier;
    private final BiConsumer<Consumer<Component>, ModItemUtils.EquipmentType> tooltipMethod;

    public ModEndgameCrossbowItem(ModItemUtils.EndgameTier tier, Item.Properties properties) {
        super(properties);
        this.endgameTier = tier;
        switch (tier) {
            case COBALT_STEEL: {
                this.tooltipMethod = ModItemUtils::appendCobaltSteelEquipmentTooltip;
                break;
            }
            case INFUSED_GEMSTONE: {
                this.tooltipMethod = ModItemUtils::appendInfusedGemstoneEquipmentTooltip;
                break;
            }
            case TUNGSTEN_CARBIDE: {
                this.tooltipMethod = ModItemUtils::appendTungstenCarbideEquipmentTooltip;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tier));
            }
        }
    }

    @NotNull
    protected Projectile createProjectile(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack weaponStack, ItemStack arrowStack, boolean crit) {
        if (arrowStack.is(Items.FIREWORK_ROCKET)) {
            return new FireworkRocketEntity(level, arrowStack, (Entity)livingEntity, livingEntity.getX(), livingEntity.getEyeY() - (double)0.15f, livingEntity.getZ(), true);
        }
        AbstractArrow projectile = this.customArrowEntity(level, livingEntity, arrowStack, weaponStack, crit);
        projectile.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        return projectile;
    }

    private AbstractArrow customArrowEntity(Level level, LivingEntity entity, ItemStack projectileStack, ItemStack weaponStack, boolean critical) {
        AbstractArrow abstractArrow = ModItemUtils.createCustomArrow(level, entity, projectileStack, weaponStack, this.endgameTier);
        if (critical) {
            abstractArrow.setCritArrow(true);
        }
        return abstractArrow;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flag) {
        this.tooltipMethod.accept(tooltip, ModItemUtils.EquipmentType.RANGED);
        super.appendHoverText(stack, context, display, tooltip, flag);
    }
}

