/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4051;
import net.minecraft.class_5532;
import net.minecraft.class_5534;
import org.jetbrains.annotations.Nullable;

public class ModStareOrMoveGoal
extends class_1352 {
    protected final class_1314 mob;
    private State state = State.IDLE;
    @Nullable
    protected class_1309 lookTarget;
    protected final float lookRange;
    private final double lookRangeSquared;
    protected final Class<? extends class_1309> lookTargetType;
    protected final class_4051 lookTargetPredicate;
    public static final int DEFAULT_INTERVAL = 120;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double moveSpeedModifier;
    protected int interval;
    protected boolean moveIgnoringChance;
    private final boolean checkNoActionTime;
    private final float moveProbability;
    private int staringForTicks = 0;
    private static final int STARING_FOR_TICKS_ANGER_THRESHOLD = 200;

    public ModStareOrMoveGoal(class_1314 mob, Class<? extends class_1309> targetType, float range, double moveSpeedModifier, float moveProbability) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        this.lookTargetType = targetType;
        this.lookRange = range;
        this.lookRangeSquared = (double)this.lookRange * (double)this.lookRange;
        if (targetType == class_1657.class) {
            Predicate predicate = class_1301.method_5913((class_1297)mob);
            this.lookTargetPredicate = class_4051.method_36626().method_18418((double)range).method_18420((entity, world) -> predicate.test(entity));
        } else {
            this.lookTargetPredicate = class_4051.method_36626().method_18418((double)range);
        }
        this.moveSpeedModifier = moveSpeedModifier;
        this.moveProbability = moveProbability;
        this.interval = 120;
        this.checkNoActionTime = true;
    }

    public boolean method_6264() {
        class_243 vec3;
        if (this.findNewLookTarget()) {
            return true;
        }
        if (!this.moveIgnoringChance) {
            if (this.checkNoActionTime && this.mob.method_6131() >= 100) {
                return false;
            }
            if (this.mob.method_59922().method_43048(ModStareOrMoveGoal.method_38848((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((vec3 = this.getRandomWanderTarget()) == null) {
            return false;
        }
        this.wantedX = vec3.field_1352;
        this.wantedY = vec3.field_1351;
        this.wantedZ = vec3.field_1350;
        this.moveIgnoringChance = false;
        return true;
    }

    protected boolean findNewLookTarget() {
        class_3218 serverLevel = ModStareOrMoveGoal.method_64451((class_1297)this.mob);
        this.lookTarget = this.lookTargetType == class_1657.class ? serverLevel.method_64389(this.lookTargetPredicate, (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321()) : serverLevel.method_64393(serverLevel.method_8390(this.lookTargetType, this.mob.method_5829().method_1009((double)this.lookRange, 3.0, (double)this.lookRange), p_148124_ -> true), this.lookTargetPredicate, (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321());
        return this.lookTarget != null && !this.lookTarget.method_7325();
    }

    protected boolean checkLookTargetIsValid() {
        if (this.lookTarget != null && this.lookTarget.method_5805()) {
            if (this.lookTarget.method_7325()) {
                return false;
            }
            return this.mob.method_5858((class_1297)this.lookTarget) <= this.lookRangeSquared;
        }
        return false;
    }

    @Nullable
    protected class_243 getRandomWanderTarget() {
        if (this.mob.method_5799()) {
            class_243 vec3 = class_5534.method_31527((class_1314)this.mob, (int)15, (int)7);
            if (vec3 == null) {
                vec3 = class_5532.method_31510((class_1314)this.mob, (int)10, (int)7);
            }
            return vec3;
        }
        return this.mob.method_59922().method_43057() >= this.moveProbability ? class_5534.method_31527((class_1314)this.mob, (int)15, (int)7) : class_5532.method_31510((class_1314)this.mob, (int)10, (int)7);
    }

    public boolean method_6266() {
        if (this.state == State.LOOKING) {
            return this.checkLookTargetIsValid();
        }
        if (this.state == State.MOVING) {
            if (this.findNewLookTarget()) {
                return false;
            }
            return !this.mob.method_5942().method_6357();
        }
        return false;
    }

    public void method_6269() {
        if (this.lookTarget != null && this.lookTarget.method_5805()) {
            this.state = State.LOOKING;
        } else {
            this.mob.method_5942().method_6337(this.wantedX, this.wantedY, this.wantedZ, this.moveSpeedModifier);
            this.state = State.MOVING;
        }
    }

    public void method_6270() {
        this.lookTarget = null;
        this.mob.method_5942().method_6340();
        super.method_6270();
        this.staringForTicks = 0;
        this.state = State.IDLE;
    }

    public void method_6268() {
        if (this.state == State.LOOKING && this.lookTarget != null && this.lookTarget.method_5805()) {
            double lookTargetEyeY = this.lookTarget.method_23320();
            this.mob.method_5988().method_20248(this.lookTarget.method_23317(), lookTargetEyeY, this.lookTarget.method_23321());
            class_1309 class_13092 = this.lookTarget;
            if (!(class_13092 instanceof class_1657)) {
                return;
            }
            class_1657 player = (class_1657)class_13092;
            if (player.method_68878()) {
                this.staringForTicks = 0;
                return;
            }
            ++this.staringForTicks;
            if (this.staringForTicks > 200) {
                this.doAngerAtTargetChance();
            }
        }
    }

    private void doAngerAtTargetChance() {
        if (!this.mob.method_6057((class_1297)this.lookTarget)) {
            return;
        }
        if (this.mob.method_59922().method_43048(100) == 0) {
            this.mob.method_5980(this.lookTarget);
            this.mob.method_56078(class_3417.field_14733);
            this.mob.method_6092(new class_1293(class_1294.field_5904, 1200, 2, false, false));
            this.mob.method_6016(class_1294.field_5909);
            this.method_6270();
        }
    }

    private static enum State {
        IDLE,
        LOOKING,
        MOVING;

    }
}

