/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ModStareOrMoveGoal
extends Goal {
    protected final PathfinderMob mob;
    private State state = State.IDLE;
    @Nullable
    protected LivingEntity lookAt;
    protected final float lookDistance;
    private final double lookDistSquared;
    protected final Class<? extends LivingEntity> lookAtType;
    protected final TargetingConditions lookAtContext;
    public static final int DEFAULT_INTERVAL = 120;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private final float probability;
    private int staringForTicks = 0;
    private static final int STARING_FOR_TICKS_ANGER_THRESHOLD = 200;

    public ModStareOrMoveGoal(PathfinderMob mob, Class<? extends LivingEntity> lookAtType, float lookRange, double moveSpeedModifier, float moveProbability) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.lookAtType = lookAtType;
        this.lookDistance = lookRange;
        this.lookDistSquared = (double)lookRange * (double)lookRange;
        if (lookAtType == Player.class) {
            Predicate predicate = EntitySelector.notRiding((Entity)mob);
            this.lookAtContext = TargetingConditions.forNonCombat().range((double)lookRange).selector((p_359094_, p_359095_) -> predicate.test(p_359094_));
        } else {
            this.lookAtContext = TargetingConditions.forNonCombat().range((double)lookRange);
        }
        this.speedModifier = moveSpeedModifier;
        this.probability = moveProbability;
        this.interval = 120;
        this.checkNoActionTime = true;
    }

    public boolean canUse() {
        Vec3 vec3;
        if (this.findNewLookAtTarget()) {
            return true;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.getNoActionTime() >= 100) {
                return false;
            }
            if (this.mob.getRandom().nextInt(ModStareOrMoveGoal.reducedTickDelay((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((vec3 = this.getRandomTargetPos()) == null) {
            return false;
        }
        this.wantedX = vec3.x;
        this.wantedY = vec3.y;
        this.wantedZ = vec3.z;
        this.forceTrigger = false;
        return true;
    }

    protected boolean findNewLookAtTarget() {
        ServerLevel serverlevel = ModStareOrMoveGoal.getServerLevel((Entity)this.mob);
        this.lookAt = this.lookAtType == Player.class ? serverlevel.getNearestPlayer(this.lookAtContext, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ()) : serverlevel.getNearestEntity(serverlevel.getEntitiesOfClass(this.lookAtType, this.mob.getBoundingBox().inflate((double)this.lookDistance, 3.0, (double)this.lookDistance), p_148124_ -> true), this.lookAtContext, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        return this.lookAt != null && !this.lookAt.isSpectator();
    }

    protected boolean checkLookAtTargetIsValid() {
        if (this.lookAt != null && this.lookAt.isAlive()) {
            if (this.lookAt.isSpectator()) {
                return false;
            }
            return this.mob.distanceToSqr((Entity)this.lookAt) <= this.lookDistSquared;
        }
        return false;
    }

    @Nullable
    protected Vec3 getRandomTargetPos() {
        if (this.mob.isInWater()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
            if (vec3 == null) {
                vec3 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
            }
            return vec3;
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7) : DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
    }

    public boolean canContinueToUse() {
        if (this.state == State.LOOKING) {
            return this.checkLookAtTargetIsValid();
        }
        if (this.state == State.MOVING) {
            if (this.findNewLookAtTarget()) {
                return false;
            }
            return !this.mob.getNavigation().isDone();
        }
        return false;
    }

    public void start() {
        if (this.lookAt != null && this.lookAt.isAlive()) {
            this.state = State.LOOKING;
        } else {
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
            this.state = State.MOVING;
        }
    }

    public void stop() {
        this.lookAt = null;
        this.mob.getNavigation().stop();
        super.stop();
        this.staringForTicks = 0;
        this.state = State.IDLE;
    }

    public void tick() {
        if (this.state == State.LOOKING && this.lookAt != null && this.lookAt.isAlive()) {
            double lookAtTargetEyeY = this.lookAt.getEyeY();
            this.mob.getLookControl().setLookAt(this.lookAt.getX(), lookAtTargetEyeY, this.lookAt.getZ());
            LivingEntity livingEntity = this.lookAt;
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            if (player.isCreative()) {
                this.staringForTicks = 0;
                return;
            }
            ++this.staringForTicks;
            if (this.staringForTicks > 200) {
                this.doAngerAtTargetChance(this.lookAt);
            }
        }
    }

    private void doAngerAtTargetChance(LivingEntity lookAtNonNull) {
        if (!this.mob.hasLineOfSight((Entity)lookAtNonNull)) {
            return;
        }
        if (this.mob.getRandom().nextInt(100) == 0) {
            this.mob.setTarget(lookAtNonNull);
            this.mob.playSound(SoundEvents.RAVAGER_ROAR);
            this.mob.addEffect(new MobEffectInstance(MobEffects.SPEED, 1200, 2, false, false));
            this.mob.removeEffect(MobEffects.SLOWNESS);
            this.stop();
        }
    }

    private static enum State {
        IDLE,
        LOOKING,
        MOVING;

    }
}

