/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.worldgen;

import java.util.List;
import net.dollar.apex.block.ModBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> RUBY_ORE_KEY = ModConfiguredFeatures.registerKey("ruby_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAPPHIRE_ORE_KEY = ModConfiguredFeatures.registerKey("sapphire_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COBALT_ORE_KEY = ModConfiguredFeatures.registerKey("cobalt_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PHOSPHATE_ORE_KEY = ModConfiguredFeatures.registerKey("phosphate_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_KEY = ModConfiguredFeatures.registerKey("tin_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_SMALL_KEY = ModConfiguredFeatures.registerKey("tin_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TUNGSTEN_ORE_KEY = ModConfiguredFeatures.registerKey("tungsten_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> rubyOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.RUBY_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_RUBY_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> sapphireOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.SAPPHIRE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_SAPPHIRE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> cobaltOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.COBALT_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_COBALT_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> phosphateOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.PHOSPHATE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_PHOSPHATE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> tinOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.TIN_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_TIN_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> tungstenOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.TUNGSTEN_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_TUNGSTEN_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, RUBY_ORE_KEY, Feature.ORE, new OreConfiguration(rubyOres, 3));
        ModConfiguredFeatures.register(context, SAPPHIRE_ORE_KEY, Feature.ORE, new OreConfiguration(sapphireOres, 3));
        ModConfiguredFeatures.register(context, COBALT_ORE_KEY, Feature.ORE, new OreConfiguration(cobaltOres, 4));
        ModConfiguredFeatures.register(context, TUNGSTEN_ORE_KEY, Feature.ORE, new OreConfiguration(tungstenOres, 12, 0.33f));
        ModConfiguredFeatures.register(context, PHOSPHATE_ORE_KEY, Feature.ORE, new OreConfiguration(phosphateOres, 7));
        ModConfiguredFeatures.register(context, TIN_ORE_KEY, Feature.ORE, new OreConfiguration(tinOres, 8));
        ModConfiguredFeatures.register(context, TIN_ORE_SMALL_KEY, Feature.ORE, new OreConfiguration(tinOres, 4));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"apex", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

