/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.entity.custom;

import java.util.List;
import java.util.UUID;
import net.dollar.apex.entity.goal.ModMeleeAttackGoal;
import net.dollar.apex.entity.goal.ModStareOrMoveGoal;
import net.dollar.apex.item.ModItems;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MysteriousSpecterEntity
extends class_1588
implements class_5354 {
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    @Nullable
    private UUID angryAt;
    private int ticksSinceLastAttack = 0;
    private static final int DEFAULT_LAST_ATTACK_TICKS_THRESHOLD = 100;
    private int auraCounterTicks = 60;
    private int abilityCooldownTicks = 100;
    private static final int DEFAULT_ABILITY_COOLDOWN_TICKS = 100;

    public MysteriousSpecterEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new ModMeleeAttackGoal((class_1314)this, 1.0, false, 40));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
        this.field_6201.method_6277(3, (class_1352)new ModStareOrMoveGoal((class_1314)this, class_1657.class, 10.0f, 0.666, 0.001f));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23722, 0.5).method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_47761, 1.0);
    }

    protected class_238 method_53511() {
        return super.method_53511().method_1009(0.1, 0.0, 0.1);
    }

    protected int method_6130(int air) {
        return air;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        this.method_29517(view);
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.method_29512(this.method_37908(), view);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        this.ticksSinceLastAttack = 0;
        if (super.method_6121(world, target)) {
            this.resetMovementSpeed();
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                if (this.field_5974.method_43048(100) < 50) {
                    livingEntity.method_6092(new class_1293(class_1294.field_5920, 81, this.calcWitherStrength(), false, false, true));
                }
            }
            this.method_6033(this.method_6032() + 2.0f);
            return true;
        }
        return false;
    }

    private int calcWitherStrength() {
        double strength = 1.0 - (double)(this.method_6032() / this.method_6063());
        strength *= 3.0;
        strength = Math.floor(strength);
        return (int)strength;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14991;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14580;
    }

    @Nullable
    protected class_3414 method_5994() {
        return switch (this.method_59922().method_43048(5)) {
            case 0 -> class_3417.field_14991;
            case 1 -> class_3417.field_14680;
            case 2 -> class_3417.field_15056;
            case 3 -> class_3417.field_14566;
            case 4 -> class_3417.field_38078;
            default -> null;
        };
    }

    public int method_5970() {
        return 300;
    }

    protected float method_6107() {
        return 0.666f;
    }

    protected void method_59928() {
        this.method_56078(class_3417.field_15240);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        --this.auraCounterTicks;
        if (this.auraCounterTicks <= 0) {
            this.applyWeaknessHungerAura();
            this.auraCounterTicks = 60;
        }
        if (this.method_5968() == null) {
            this.ticksSinceLastAttack = 0;
            return;
        }
        ++this.ticksSinceLastAttack;
        --this.abilityCooldownTicks;
        if (this.ticksSinceLastAttack >= 100 && this.abilityCooldownTicks <= 0 && this.field_5974.method_43048(100) == 0) {
            this.blindAndSlowNearbyPlayers();
            this.increaseMovementSpeedTemporarily();
            if (this.ticksSinceLastAttack >= 150) {
                this.witherAndDamageNearbyPlayers(serverWorld);
            }
            this.abilityCooldownTicks = 100;
        }
    }

    private void applyWeaknessHungerAura() {
        double radius = 10.0;
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        List players = this.method_37908().method_8390(class_1657.class, new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), class_1301.field_6156);
        for (class_1657 player : players) {
            player.method_6092(new class_1293(class_1294.field_5911, 200, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5903, 200, 0, false, false, true));
        }
    }

    private void blindAndSlowNearbyPlayers() {
        double radius = 24.0;
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        List players = this.method_37908().method_8390(class_1657.class, new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), class_1301.field_6156);
        switch (this.field_5974.method_43048(3)) {
            case 0: {
                this.method_56078(class_3417.field_14713);
                break;
            }
            case 1: {
                this.method_56078(class_3417.field_38063);
                break;
            }
            default: {
                this.method_56078(class_3417.field_14733);
            }
        }
        for (class_1657 player : players) {
            player.method_6092(new class_1293(class_1294.field_5909, 60, 1, false, false, true));
            player.method_6092(new class_1293(class_1294.field_38092, 60, 0, false, false, true));
        }
    }

    private void witherAndDamageNearbyPlayers(class_3218 serverWorld) {
        double radius = 24.0;
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        List players = this.method_37908().method_8390(class_1657.class, new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius), class_1301.field_6156);
        int intensity = this.calcWitherStrength();
        for (class_1657 player : players) {
            player.method_6092(new class_1293(class_1294.field_5920, 81, intensity, false, false, true));
            player.method_64397(serverWorld, this.method_48923().method_48812((class_1309)this), 5.0f);
        }
    }

    private void increaseMovementSpeedTemporarily() {
        this.method_6092(new class_1293(class_1294.field_5904, 1200, 2, false, false));
        this.method_6016(class_1294.field_5909);
    }

    private void resetMovementSpeed() {
        if (this.method_6059(class_1294.field_5904)) {
            this.method_6016(class_1294.field_5904);
        }
    }

    public boolean method_6049(class_1293 effect) {
        class_6880 statusEffect = effect.method_5579();
        return statusEffect != class_1294.field_5899 && statusEffect != class_1294.field_5920;
    }

    protected void method_16077(class_3218 world, class_1282 damageSource, boolean causedByPlayer) {
        class_1542 collectorItem;
        class_1657 playerEntity;
        class_1799 heldItem;
        class_1297 class_12972;
        if (!causedByPlayer) {
            return;
        }
        class_1542 itemEntity = this.method_5706(world, (class_1935)ModItems.HANDFUL_OF_STARDUST);
        if (itemEntity != null) {
            itemEntity.method_6976();
        }
        if ((class_12972 = damageSource.method_5529()) instanceof class_1657 && ((heldItem = (playerEntity = (class_1657)class_12972).method_6118(class_1304.field_6173)).method_7909() == class_1802.field_22026 || heldItem.method_7909() == ModItems.COBALT_STEEL_HOE || heldItem.method_7909() == ModItems.INFUSED_GEMSTONE_HOE || heldItem.method_7909() == ModItems.TUNGSTEN_CARBIDE_HOE) && (collectorItem = this.method_5706(world, (class_1935)ModItems.TROPHY_OMINOUS_LETTER)) != null) {
            collectorItem.method_6976();
        }
    }

    public int method_6110(class_3218 world) {
        return 50;
    }

    public int method_5850() {
        return 10;
    }

    public boolean method_5753() {
        return true;
    }

    public static boolean checkMysteriousSpecterSpawnRules(class_1299<MysteriousSpecterEntity> mysteriousSpecterEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        if (serverWorldAccess.method_23753(blockPos).method_40225(class_1972.field_9462)) {
            return false;
        }
        if (blockPos.method_10264() < 62) {
            return false;
        }
        return MysteriousSpecterEntity.method_20680(mysteriousSpecterEntityType, (class_5425)serverWorldAccess, (class_3730)spawnReason, (class_2338)blockPos, (class_5819)random);
    }

    protected boolean method_23734() {
        return super.method_23734();
    }
}

