/*
 * Decompiled with CFR 0.152.
 */
package net.aenead.matrixbridge;

import net.aenead.matrixbridge.BridgeCommands;
import net.aenead.matrixbridge.MessageHandler;
import net.aenead.matrixbridge.commands.CommandMatrixbridge;
import net.aenead.matrixbridge.config.Config;
import net.aenead.matrixbridge.config.IConfig;
import net.aenead.matrixbridge.config.exceptions.ConfigInitException;
import net.aenead.matrixbridge.matrix.Bot;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;

public class Bridge
implements ModInitializer,
GameStartEntrypoint,
RecipeEntrypoint {
    public static final String MOD_ID = "matrix-bridge";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MatrixBridge");
    public static final String CONFIGDIR = FabricLoaderImpl.INSTANCE.getConfigDir().toString() + "/matrix-bridge";
    public static final int CONFIGVER = 2;
    public static IConfig config;
    public static Bot bot;
    public static MinecraftServer server;

    public static boolean loadConfig() {
        try {
            config = new Config(CONFIGDIR + "/config.yaml");
        }
        catch (ConfigInitException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        if (config.getVersion() != 2) {
            LOGGER.error("Please regenerate configuration");
            return false;
        }
        return true;
    }

    public static boolean reload() {
        if (!Bridge.loadConfig()) {
            return false;
        }
        bot.updateSettings(LOGGER, config.getHomeserver(), config.getUsername(), config.getPassword(), config.getDeviceName(), config.getVerifyType(), config.getVerifyToken(), config.getRoom(), config.getVerbose(), CONFIGDIR, config.getDatabaseType(), config.getDatabaseName(), config.getDatabaseHostname(), config.getDatabaseUsername(), config.getDatabasePassword());
        bot.reload();
        return true;
    }

    public void onInitialize() {
        if (!Bridge.loadConfig()) {
            return;
        }
        CommandMatrixbridge.registerManagementCommands();
        bot = new Bot(LOGGER, config.getHomeserver(), config.getUsername(), config.getPassword(), config.getDeviceName(), config.getVerifyType(), config.getVerifyToken(), config.getRoom(), config.getVerbose(), CONFIGDIR, config.getDatabaseType(), config.getDatabaseName(), config.getDatabaseHostname(), config.getDatabaseUsername(), config.getDatabasePassword());
        bot.start();
    }

    public void beforeGameStart() {
    }

    public void afterGameStart() {
        server = MinecraftServer.getInstance();
        if (!bot.getActive()) {
            return;
        }
        BridgeCommands.registerBridgeCommands();
        MessageHandler.serverStart();
    }

    public void onRecipesReady() {
    }

    public void initNamespaces() {
    }
}

