/*
 * Decompiled with CFR 0.152.
 */
package net.aenead.matrixbridge;

import java.util.HashMap;
import net.aenead.matrixbridge.Bridge;
import net.aenead.matrixbridge.BridgeCommandRef;
import net.aenead.matrixbridge.Utility;
import net.aenead.matrixbridge.Whitelisting;
import net.minecraft.core.entity.player.Player;
import net.minecraft.server.entity.player.PlayerServer;

public class BridgeCommands {
    private static HashMap<String, BridgeCommandRef> COMMANDS = new HashMap();

    public static void registerBridgeCommands() {
        COMMANDS.put("ping", BridgeCommands::ping);
        COMMANDS.put("list", BridgeCommands::list);
        COMMANDS.put("invite", BridgeCommands::invite);
    }

    public static void handleCommand(String command, String argument) {
        try {
            COMMANDS.get(command).execute(argument);
        }
        catch (NullPointerException e) {
            Bridge.bot.sendMessageHTML(BridgeCommands.getCommandList());
        }
    }

    private static void ping(String argument) {
        if (!Bridge.config.isCommandPingEnabled().booleanValue()) {
            Bridge.bot.sendMessage(Bridge.config.getMessageDisabledCommand());
            return;
        }
        Bridge.bot.sendMessage(Bridge.config.getMessageCommandPing());
    }

    private static void list(String argument) {
        if (!Bridge.config.isCommandListEnabled().booleanValue()) {
            Bridge.bot.sendMessage(Bridge.config.getMessageDisabledCommand());
            return;
        }
        StringBuilder players = new StringBuilder();
        for (PlayerServer p : Bridge.server.playerList.playerEntities) {
            players.append(Utility.getUnformattedName((Player)p));
            players.append(" ");
        }
        Bridge.bot.sendMessage(Bridge.config.getMessageCommandList().replace("%players%", players.toString()));
    }

    private static void invite(String argument) {
        String msg;
        if (!Bridge.config.isCommandInviteEnabled().booleanValue()) {
            Bridge.bot.sendMessage(Bridge.config.getMessageDisabledCommand());
            return;
        }
        switch (Whitelisting.whitelistPlayer(argument)) {
            case 0: {
                msg = Bridge.config.getMessageWhitelistAlready().replace("%player%", argument);
                break;
            }
            case 1: {
                msg = Bridge.config.getMessageWhitelistSuccess().replace("%player%", argument);
                break;
            }
            case 2: {
                msg = Bridge.config.getMessageWhitelistError().replace("%player%", argument);
                break;
            }
            default: {
                msg = "Unknown error! This is a bug, please report it immediately!";
            }
        }
        Bridge.bot.sendMessage(msg);
    }

    public static String getCommandList() {
        StringBuilder str = new StringBuilder();
        str.append("<ul>");
        COMMANDS.forEach((command, ref) -> {
            str.append("<li> !");
            str.append((String)command);
            str.append("</li>");
        });
        str.append("</ul>");
        return Bridge.config.getMessageInvalidCommand().replace("%commands%", str.toString());
    }
}

