/*
 * Decompiled with CFR 0.152.
 */
package net.aenead.matrixbridge;

import net.aenead.matrixbridge.Bridge;
import net.aenead.matrixbridge.BridgeCommands;
import net.aenead.matrixbridge.matrix.wrappers.MatrixUser;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketChat;

public class MessageHandler {
    public static void serverStart() {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageStartEnabled().booleanValue()) {
            return;
        }
        Bridge.bot.sendMessage(Bridge.config.getMessageStart());
    }

    public static void serverStop() {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageStopEnabled().booleanValue()) {
            return;
        }
        Bridge.bot.sendMessage(Bridge.config.getMessageStop());
    }

    public static void sendPlayers(MatrixUser user, String message) {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageMX2MCEnabled().booleanValue()) {
            return;
        }
        if (message.startsWith("!")) {
            String command = message.contains(" ") ? message.substring(1, message.indexOf(" ")) : message.substring(1);
            String argument = message.contains(" ") ? message.substring(message.indexOf(" ") + 1) : "";
            BridgeCommands.handleCommand(command, argument);
            return;
        }
        String sending = Bridge.config.getMessageMX2MC().replace("%player%", user.getDisplayName()) + message;
        Bridge.LOGGER.info(sending);
        Bridge.server.playerList.sendPacketToAllPlayers((Packet)new PacketChat(sending));
    }

    public static void sendMatrix(String player, String message) {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageMC2MXEnabled().booleanValue()) {
            return;
        }
        String sending = Bridge.config.getMessageMC2MX().replace("%player%", player) + message;
        Bridge.bot.sendMessage(sending);
    }

    public static void playerJoin(String message) {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageJoinEnabled().booleanValue()) {
            return;
        }
        String sending = Bridge.config.getMessageJoin().replace("%player%", message);
        Bridge.bot.sendMessage(sending);
    }

    public static void playerQuit(String message) {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageQuitEnabled().booleanValue()) {
            return;
        }
        String sending = Bridge.config.getMessageQuit().replace("%player%", message);
        Bridge.bot.sendMessage(sending);
    }

    public static void playerDeath(String message) {
        if (!Bridge.bot.getActive() || !Bridge.config.isMessageDeathEnabled().booleanValue()) {
            return;
        }
        String sending = Bridge.config.getMessageDeath().replace("%message%", message);
        Bridge.bot.sendMessage(sending);
    }
}

