/*
 * Decompiled with CFR 0.152.
 */
package net.aenead.matrixbridge.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import net.aenead.matrixbridge.Bridge;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;

@Environment(value=EnvType.SERVER)
public class CommandRoom
implements CommandManager.CommandRegistry {
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        ArgumentBuilderLiteral room = ArgumentBuilderLiteral.literal((String)"room");
        room.requires(CommandSource::hasAdmin);
        ArgumentBuilderLiteral join = ArgumentBuilderLiteral.literal((String)"join");
        join.requires(CommandSource::hasAdmin);
        ArgumentBuilderRequired joinArg = ArgumentBuilderRequired.argument((String)"roomId", (ArgumentType)ArgumentTypeString.greedyString());
        joinArg.requires(CommandSource::hasAdmin);
        joinArg.executes(this::checkJoin);
        join.then((ArgumentBuilder)joinArg);
        ArgumentBuilderLiteral leave = ArgumentBuilderLiteral.literal((String)"leave");
        leave.requires(CommandSource::hasAdmin);
        ArgumentBuilderRequired leaveArg = ArgumentBuilderRequired.argument((String)"roomId", (ArgumentType)ArgumentTypeString.greedyString());
        leaveArg.requires(CommandSource::hasAdmin);
        leaveArg.executes(this::checkLeave);
        leave.then((ArgumentBuilder)leaveArg);
        room.then((ArgumentBuilder)join);
        room.then((ArgumentBuilder)leave);
        dispatcher.getRoot().getChild("matrixbridge").addChild((CommandNode)room.build());
    }

    private int checkJoin(CommandContext<CommandSource> context) {
        return this.executeJoin((CommandSource)context.getSource(), (String)context.getArgument("roomId", String.class));
    }

    private int executeJoin(CommandSource source, String roomId) {
        boolean result = Bridge.bot.joinRoom(roomId);
        if (result) {
            source.sendMessage("Successfully joined room " + roomId);
        } else {
            source.sendMessage("Unable to discover room " + roomId);
        }
        return 1;
    }

    private int checkLeave(CommandContext<CommandSource> context) {
        return this.executeLeave((CommandSource)context.getSource(), (String)context.getArgument("roomId", String.class));
    }

    private int executeLeave(CommandSource source, String roomId) {
        Bridge.bot.leaveRoom(roomId);
        source.sendMessage("Successfully left room " + roomId);
        return 1;
    }
}

