/*
 * Decompiled with CFR 0.152.
 */
package net.aenead.matrixbridge.config;

import net.aenead.matrixbridge.config.ConfigCore;
import net.aenead.matrixbridge.config.IConfig;
import net.aenead.matrixbridge.config.exceptions.ConfigInitException;
import net.aenead.matrixbridge.matrix.DatabaseType;
import net.aenead.matrixbridge.matrix.VerifyType;

public class Config
extends ConfigCore
implements IConfig {
    private Integer version;
    private Boolean verbose;
    private String homeserver;
    private String username;
    private String password;
    private String deviceName;
    private VerifyType verifyType;
    private String verifyToken;
    private String room;
    private DatabaseType databaseType;
    private String databaseName;
    private String databaseHostname;
    private String databaseUsername;
    private String databasePassword;
    private Boolean commandListEnabled;
    private Boolean commandPingEnabled;
    private Boolean commandInviteEnabled;
    private String messageMX2MC;
    private Boolean messageMX2MCEnabled;
    private String messageMC2MX;
    private Boolean messageMC2MXEnabled;
    private String messageStart;
    private Boolean messageStartEnabled;
    private String messageStop;
    private Boolean messageStopEnabled;
    private String messageJoin;
    private Boolean messageJoinEnabled;
    private String messageQuit;
    private Boolean messageQuitEnabled;
    private String messageDeath;
    private Boolean messageDeathEnabled;
    private String commandListMessage;
    private String commandPingMessage;
    private String commandInvalidMessage;
    private String commandDisabledMessage;
    private String commandInviteMessageSuccess;
    private String commandInviteMessageError;
    private String commandInviteMessageAlready;

    public Config(String path) throws ConfigInitException {
        super(path);
        this.fill();
    }

    private void fill() {
        this.version = this.conf.getInt("version");
        this.verbose = this.conf.getBoolean("verbose");
        this.homeserver = this.conf.getString("account.homeserver");
        this.username = this.conf.getString("account.username");
        this.password = this.conf.getString("account.password");
        this.deviceName = this.conf.getString("account.device_name");
        this.room = this.conf.getString("account.room");
        try {
            this.verifyType = VerifyType.valueOf(this.conf.getString("verification.type"));
        }
        catch (IllegalArgumentException e) {
            this.verifyType = VerifyType.DISABLED;
        }
        this.verifyToken = this.conf.getString("verification.token");
        try {
            this.databaseType = DatabaseType.valueOf(this.conf.getString("database.type"));
        }
        catch (IllegalArgumentException e) {
            this.databaseType = DatabaseType.H2;
        }
        this.databaseName = this.conf.getString("database.name");
        this.databaseHostname = this.conf.getString("database.hostname");
        this.databaseUsername = this.conf.getString("database.username");
        this.databasePassword = this.conf.getString("database.password");
        this.commandListEnabled = this.conf.getBoolean("commands.list.enabled");
        this.commandListMessage = this.conf.getString("commands.list.format");
        this.commandPingEnabled = this.conf.getBoolean("commands.ping.enabled");
        this.commandPingMessage = this.conf.getString("commands.ping.format");
        this.commandInviteEnabled = this.conf.getBoolean("commands.invite.enabled");
        this.commandInviteMessageSuccess = this.conf.getString("commands.invite.format.success");
        this.commandInviteMessageError = this.conf.getString("commands.invite.format.error");
        this.commandInviteMessageAlready = this.conf.getString("commands.invite.format.already");
        this.commandInvalidMessage = this.conf.getString("commands.invalid_command");
        this.commandDisabledMessage = this.conf.getString("commands.disabled_command");
        this.messageStart = this.conf.getString("messages.start.format");
        this.messageStartEnabled = this.conf.getBoolean("messages.start.enabled");
        this.messageStop = this.conf.getString("messages.stop.format");
        this.messageStopEnabled = this.conf.getBoolean("messages.stop.enabled");
        this.messageMX2MC = this.conf.getString("messages.chat_matrix_to_minecraft.format");
        this.messageMX2MCEnabled = this.conf.getBoolean("messages.chat_matrix_to_minecraft.enabled");
        this.messageMC2MX = this.conf.getString("messages.chat_minecraft_to_matrix.format");
        this.messageMC2MXEnabled = this.conf.getBoolean("messages.chat_minecraft_to_matrix.enabled");
        this.messageJoin = this.conf.getString("messages.player_join.format");
        this.messageJoinEnabled = this.conf.getBoolean("messages.player_join.enabled");
        this.messageQuit = this.conf.getString("messages.player_quit.format");
        this.messageQuitEnabled = this.conf.getBoolean("messages.player_quit.enabled");
        this.messageDeath = this.conf.getString("messages.player_death.format");
        this.messageDeathEnabled = this.conf.getBoolean("messages.player_death.enabled");
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public Boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public String getHomeserver() {
        return this.homeserver;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public VerifyType getVerifyType() {
        return this.verifyType;
    }

    @Override
    public String getVerifyToken() {
        return this.verifyToken;
    }

    @Override
    public String getRoom() {
        return this.room;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    @Override
    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    @Override
    public String getDatabasePassword() {
        return this.databasePassword;
    }

    @Override
    public Boolean isCommandListEnabled() {
        return this.commandListEnabled;
    }

    @Override
    public Boolean isCommandPingEnabled() {
        return this.commandPingEnabled;
    }

    @Override
    public Boolean isCommandInviteEnabled() {
        return this.commandInviteEnabled;
    }

    @Override
    public String getMessageMX2MC() {
        return this.messageMX2MC;
    }

    @Override
    public Boolean isMessageMX2MCEnabled() {
        return this.messageMX2MCEnabled;
    }

    @Override
    public String getMessageMC2MX() {
        return this.messageMC2MX;
    }

    @Override
    public Boolean isMessageMC2MXEnabled() {
        return this.messageMC2MXEnabled;
    }

    @Override
    public String getMessageStart() {
        return this.messageStart;
    }

    @Override
    public Boolean isMessageStartEnabled() {
        return this.messageStartEnabled;
    }

    @Override
    public String getMessageStop() {
        return this.messageStop;
    }

    @Override
    public Boolean isMessageStopEnabled() {
        return this.messageStopEnabled;
    }

    @Override
    public String getMessageJoin() {
        return this.messageJoin;
    }

    @Override
    public Boolean isMessageJoinEnabled() {
        return this.messageJoinEnabled;
    }

    @Override
    public String getMessageQuit() {
        return this.messageQuit;
    }

    @Override
    public Boolean isMessageQuitEnabled() {
        return this.messageQuitEnabled;
    }

    @Override
    public String getMessageDeath() {
        return this.messageDeath;
    }

    @Override
    public Boolean isMessageDeathEnabled() {
        return this.messageDeathEnabled;
    }

    @Override
    public String getMessageCommandList() {
        return this.commandListMessage;
    }

    @Override
    public String getMessageCommandPing() {
        return this.commandPingMessage;
    }

    @Override
    public String getMessageInvalidCommand() {
        return this.commandInvalidMessage;
    }

    @Override
    public String getMessageDisabledCommand() {
        return this.commandDisabledMessage;
    }

    @Override
    public String getMessageWhitelistSuccess() {
        return this.commandInviteMessageSuccess;
    }

    @Override
    public String getMessageWhitelistError() {
        return this.commandInviteMessageError;
    }

    @Override
    public String getMessageWhitelistAlready() {
        return this.commandInviteMessageAlready;
    }
}

