/*
 * Decompiled with CFR 0.152.
 */
package net.aenead.matrixbridge.config;

import java.io.IOException;
import net.aenead.matrixbridge.config.exceptions.ConfigInitException;
import org.simpleyaml.configuration.comments.format.YamlCommentFormat;
import org.simpleyaml.configuration.file.YamlFile;
import org.simpleyaml.configuration.implementation.api.QuoteStyle;

public class ConfigCore {
    protected final YamlFile conf;

    public ConfigCore(String path) throws ConfigInitException {
        this.conf = new YamlFile(path);
        this.loadSettings();
        try {
            this.conf.loadWithComments();
        }
        catch (IOException e) {
            this.initFile();
        }
    }

    private void loadSettings() {
        this.conf.setCommentFormat(YamlCommentFormat.BLANK_LINE);
        this.conf.options().quoteStyleDefaults().setDefaultQuoteStyle(QuoteStyle.PLAIN);
        this.conf.options().quoteStyleDefaults().setQuoteStyle(String.class, QuoteStyle.DOUBLE);
    }

    private void initFile() {
        try {
            this.conf.createNewFile(true);
            this.loadDefaults();
            this.conf.save();
        }
        catch (IOException e) {
            throw new ConfigInitException("Unknown error initialising config. Message: " + e.getMessage());
        }
    }

    private void loadDefaults() {
        this.conf.setHeader("+---------------------------------------------------+\n|                                                   |\n|            Matrix Bridge Configuration            |\n|                                                   |\n+---------------------------------------------------+\nPlease ensure that all values follow the YAML standard.\nIndentation is important! Tabs are not allowed.\nRefer to \"https://www.tutorialspoint.com/yaml/\" for a detailed explanation.\n\nImproperly set values will default. Integers -> 0, Booleans -> false, Verify Type -> DISABLED, Database Type -> H2.\nPlease ensure your values are set properly!\n\nThis file is never modified. This file is only written to when it is being generated.\nThis file is comment-safe. They will not disappear.\n\nIf you need assistance, please join our Matrix room \"https://matrix.to/#/#sophie.projects:aenead.net\".\nThank you! <3");
        this.conf.path("version").set((Object)2).comment("# DO NOT MODIFY. Used to detect when you need to update config.", YamlCommentFormat.RAW);
        this.conf.path("verbose").set((Object)false).comment("Reveals Trixnity log messages. Useful for debugging.");
        this.conf.setComment("account", "\n\n\n\n\n# +---------------------------------------------------+\n# |                                                   |\n# |                      Account                      |\n# |                                                   |\n# +---------------------------------------------------+\n# Settings used to sign in to the bot account.\n", YamlCommentFormat.RAW);
        this.conf.path("account.homeserver").set((Object)"https://matrix.example.org").comment("Synapse URL. Supports delegation.");
        this.conf.path("account.username").set((Object)"user").comment("Account login username. Localpart of user's MXID.");
        this.conf.path("account.password").set((Object)"pass").comment("Account login password. Does not support tokens or SSO.");
        this.conf.path("account.device_name").set((Object)"Matrix-Minecraft Bridge").comment("Bridge session device name.");
        this.conf.path("account.room").set((Object)"!sdfDsdfsA:matrix.example.org").comment("Internal ID of room to send messages to.");
        this.conf.setComment("verification", "\n\n\n\n\n# +---------------------------------------------------+\n# |                                                   |\n# |                    Verification                   |\n# |                                                   |\n# +---------------------------------------------------+\n# Settings used to enable session verification and encryption.", YamlCommentFormat.RAW);
        this.conf.path("verification.type").set((Object)"KEY").comment("Either KEY, PASSPHRASE or DISABLED. All other values will be rejected.");
        this.conf.path("verification.token").set((Object)"AaAA aaAa AAaa...").comment("Token (either a key or passphrase) to verify bridge session.");
        this.conf.setComment("database", "\n\n\n\n\n# +---------------------------------------------------+\n# |                                                   |\n# |                      Database                     |\n# |                                                   |\n# +---------------------------------------------------+\n# Settings used for database configuration.\n", YamlCommentFormat.RAW);
        this.conf.path("database.type").set((Object)"H2").comment("Either H2, SQLITE, MARIADB or POSTGRESQL. All other values will be rejected. Default is H2.");
        this.conf.path("database.name").set((Object)"database").comment("Name of database. If type is H2 or SQLITE, represents file name. Otherwise, represents database to connect to.");
        this.conf.path("database.hostname").set((Object)"localhost:3306").comment("Host and port to connect to database.");
        this.conf.path("database.username").set((Object)"user").comment("Database login username. Only used with MARIADB and POSTGRESQL.");
        this.conf.path("database.password").set((Object)"pass").comment("Database login password. Only used with MARIADB and POSTGRESQL.");
        this.conf.setComment("commands", "\n\n\n\n\n# +---------------------------------------------------+\n# |                                                   |\n# |                      Commands                     |\n# |                                                   |\n# +---------------------------------------------------+\n# Settings for bridge commands.\n", YamlCommentFormat.RAW);
        this.conf.path("commands.list").comment("'!list' command. Lists online players. Supported placeholders: %players%").setChild("format", (Object)"\ud83d\udcdc Online players: %players%").setChild("enabled", (Object)true);
        this.conf.path("commands.ping").comment("'!ping' command. Bridge prints message to ensure connection.").setChild("format", (Object)"\ud83c\udfd3 Pong!").setChild("enabled", (Object)true);
        this.conf.path("commands.invite").comment("'!invite' command. Whitelists a player. Supported placeholders: %player%").setChild("format.success", (Object)"\ud83d\udd35 '%player%' has been whitelisted!").setChild("format.error", (Object)"\ud83d\udd35 '%player%' could not be found. Usage: !invite <username>").setChild("format.already", (Object)"\ud83d\udd35 '%player%' is already whitelisted!").setChild("enabled", (Object)false);
        this.conf.path("commands.invalid_command").set((Object)"\u26d4 Command not found! Available commands: %commands%").comment("Message sent to Matrix when a performed command is invalid. Supported placeholders: %commands%");
        this.conf.path("commands.disabled_command").set((Object)"\u26d4 Command disabled! Please contact an administrator.").comment("Message sent to Matrix when a performed command is disabled.");
        this.conf.setComment("messages", "\n\n\n\n\n# +---------------------------------------------------+\n# |                                                   |\n# |                      Messages                     |\n# |                                                   |\n# +---------------------------------------------------+\n# Message formats! Some messages use placeholders. Available placeholders are stated in the comments.\n# Available placeholders: %player%, %message%, %commands%", YamlCommentFormat.RAW);
        this.conf.path("messages.start").comment("Message sent when the server starts.").setChild("format", (Object)"\u2747 Server started").setChild("enabled", (Object)true);
        this.conf.path("messages.stop").comment("Message sent when the server stops.").setChild("format", (Object)"\ud83d\uded1 Server stopped").setChild("enabled", (Object)true);
        this.conf.path("messages.chat_matrix_to_minecraft").comment("Chat message format as viewed in Minecraft. Supported placeholders: %player%").setChild("format", (Object)"[\u00a74%player%\u00a7r] ").setChild("enabled", (Object)true);
        this.conf.path("messages.chat_minecraft_to_matrix").comment("Chat message format as viewed on Matrix. Supported placeholders: %player%").setChild("format", (Object)"<%player%> ").setChild("enabled", (Object)true);
        this.conf.path("messages.player_join").comment("Message sent to Matrix when a player joins the server. Supported placeholders: %player%").setChild("format", (Object)"\ud83d\udd39 %player% joined the game").setChild("enabled", (Object)true);
        this.conf.path("messages.player_quit").comment("Message sent to Matrix when a player quits the server. Supported placeholders: %player%").setChild("format", (Object)"\ud83d\udd39 %player% left the game").setChild("enabled", (Object)true);
        this.conf.path("messages.player_death").comment("Message sent to Matrix when a player dies. Supported placeholders: %message%").setChild("format", (Object)"\ud83e\udea6 %message%").setChild("enabled", (Object)true);
    }
}

