/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.corecraft;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.corecraft.init.CoreCraftModBlocks;
import net.mcreator.corecraft.init.CoreCraftModEntities;
import net.mcreator.corecraft.init.CoreCraftModFeatures;
import net.mcreator.corecraft.init.CoreCraftModFluidTypes;
import net.mcreator.corecraft.init.CoreCraftModFluids;
import net.mcreator.corecraft.init.CoreCraftModItems;
import net.mcreator.corecraft.init.CoreCraftModMobEffects;
import net.mcreator.corecraft.init.CoreCraftModParticleTypes;
import net.mcreator.corecraft.init.CoreCraftModPotions;
import net.mcreator.corecraft.init.CoreCraftModSounds;
import net.mcreator.corecraft.init.CoreCraftModVillagerProfessions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="core_craft")
public class CoreCraftMod {
    public static final Logger LOGGER = LogManager.getLogger(CoreCraftMod.class);
    public static final String MODID = "core_craft";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("core_craft", "core_craft"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CoreCraftMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CoreCraftModSounds.REGISTRY.register(bus);
        CoreCraftModBlocks.REGISTRY.register(bus);
        CoreCraftModItems.REGISTRY.register(bus);
        CoreCraftModEntities.REGISTRY.register(bus);
        CoreCraftModParticleTypes.REGISTRY.register(bus);
        CoreCraftModMobEffects.REGISTRY.register(bus);
        CoreCraftModPotions.REGISTRY.register(bus);
        CoreCraftModFeatures.REGISTRY.register(bus);
        CoreCraftModVillagerProfessions.PROFESSIONS.register(bus);
        CoreCraftModFluids.REGISTRY.register(bus);
        CoreCraftModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

