/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.improvedcrashreports.mixin.client;

import com.imeetake.improvedcrashreports.util.CrashAnalysisResult;
import com.imeetake.improvedcrashreports.util.CrashAnalyzer;
import com.imeetake.improvedcrashreports.util.CrashCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_128.class})
public class CrashReportMixin {
    private boolean isRussianLanguage() {
        try {
            String lang = class_310.method_1551().field_1690.field_1883;
            return lang != null && lang.toLowerCase().startsWith("ru");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Inject(method={"asString"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectBetterCrashInfo(CallbackInfoReturnable<String> cir) {
        class_128 report = (class_128)this;
        Throwable cause = report.method_564();
        CrashAnalysisResult result = CrashAnalyzer.analyze(cause);
        boolean ru = this.isRussianLanguage();
        if (result == null) {
            return;
        }
        StringBuilder output = new StringBuilder();
        output.append(ru ? "================ \ud83d\udc80 Improved Crash Reports \ud83d\udc80 ================\n\n" : "================ \ud83d\udc80 Improved Crash Reports \ud83d\udc80 ================\n\n");
        output.append(String.format(ru ? "\u2757 \u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434: `%s` (%s)\n" : "\u2757 Likely cause: mod `%s` (%s)\n", result.mod().getMetadata().getId(), result.mod().getMetadata().getName()));
        output.append(String.format(ru ? "\ud83d\udcc4 \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: %s\n" : "\ud83d\udcc4 Exception: %s\n", result.exceptionName()));
        output.append(String.format(ru ? "\ud83d\udccd \u041a\u043b\u0430\u0441\u0441: %s\n" : "\ud83d\udccd Class: %s\n", result.crashClass()));
        String mcVersion = FabricLoader.getInstance().getModContainer("minecraft").map(mod -> mod.getMetadata().getVersion().getFriendlyString()).orElse("Minecraft");
        Object hint = switch (result.category()) {
            default -> throw new MatchException(null, null);
            case CrashCategory.UPDATE_MOD -> {
                if (ru) {
                    yield "\ud83d\udca1 \u041c\u043e\u0434 \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0435\u0433\u043e.\n";
                }
                yield "\ud83d\udca1 This mod seems incompatible with Minecraft " + mcVersion + ". Try updating it.\n";
            }
            case CrashCategory.BUG_IN_MOD -> {
                if (ru) {
                    yield "\ud83d\udca1 \u0412 \u043c\u043e\u0434\u0435, \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e, \u0431\u0430\u0433. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0435\u0433\u043e \u0438\u043b\u0438 \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u0430\u0432\u0442\u043e\u0440\u0443.\n";
                }
                yield "\ud83d\udca1 The mod appears to have an internal bug. Consider removing or reporting it.\n";
            }
            case CrashCategory.MOD_CONFLICT -> {
                if (ru) {
                    yield "\ud83d\udca1 \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 \u043c\u043e\u0434\u0430\u043c\u0438. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u043d\u0438\u0445.\n";
                }
                yield "\ud83d\udca1 Possible conflict between mods. Try removing one of them.\n";
            }
            case CrashCategory.UNKNOWN -> ru ? "\ud83d\udca1 \u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043d\u0435 \u044f\u0441\u043d\u0430. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u043c\u043e\u0434 \u0438\u043b\u0438 \u0438\u0449\u0438\u0442\u0435 \u043f\u043e\u043c\u043e\u0449\u044c \u0432 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0435.\n" : "\ud83d\udca1 Cause unclear. Try removing the last mod you installed or seek help online.\n";
        };
        output.append((String)hint);
        output.append(ru ? "\n================================================================\n\n" : "\n================================================================\n\n");
        if (ru) {
            output.append("\u26a0\ufe0f \u0412\u0430\u0436\u043d\u043e:\n");
            output.append("   \u041f\u0435\u0440\u0435\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c \u043c\u043e\u0434\u043e\u0432 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u043c\u0438\u0440\u0430!\n");
            output.append("   \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u043e\u0432 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u043f\u043e\u0442\u0435\u0440\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u043b\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044e \u043c\u0438\u0440\u0430.\n");
            output.append("   \u0410\u0432\u0442\u043e\u0440\u044b \u044d\u0442\u043e\u0433\u043e \u043c\u043e\u0434\u0430 \u043d\u0435 \u043d\u0435\u0441\u0443\u0442 \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0437\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u044f.\n\n");
        } else {
            output.append("\u26a0\ufe0f Important:\n");
            output.append("   Make a backup of your world before removing any mods!\n");
            output.append("   Removing mods may lead to data loss or world corruption.\n");
            output.append("   The authors of this mod are not responsible for any consequences.\n\n");
        }
        output.append((String)cir.getReturnValue());
        cir.setReturnValue((Object)output.toString());
    }
}

