/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.improvedcrashreports.util;

import com.imeetake.improvedcrashreports.util.CrashAnalysisResult;
import com.imeetake.improvedcrashreports.util.CrashCategory;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class CrashAnalyzer {
    private static final Set<String> IGNORED_MOD_IDS = Set.of("fabric-api", "fabricloader", "modmenu", "cloth-config", "architectury", "owo", "cardinal-components-base", "cardinal-components-entity", "cardinal-components-block", "cardinal-components-item", "cardinal-components-level", "cardinal-components-scoreboard", "cardinal-components-util", "cardinal-components-world", "fabric-key-binding-api-v1", "fabric-lifecycle-events-v1", "fabric-resource-loader-v0", "fabric-rendering-v1", "fabric-renderer-api-v1", "fabric-screen-api-v1", "fabric-command-api-v2", "fabric-dimensions-v1", "fabric-entity-events-v1", "fabric-model-loading-api-v1", "fabric-transfer-api-v1", "fabric-networking-api-v1", "fabric-registry-sync-v0", "fabric-item-group-api-v1", "fabric-rendering-data-attachment-v1", "fabric-game-rule-api-v1", "fabric-events-interaction-v0", "fabric-events-lifecycle-v0", "fabric-api-base", "fabric-api-lookup-api-v1", "fabric-api-transfer-v1", "midnightlib", "yet-another-config-lib", "yacl", "forgeconfigapiport", "configured");

    public static CrashAnalysisResult analyze(Throwable cause) {
        StackTraceElement[] stack;
        HashMap modScores = new HashMap();
        for (StackTraceElement element : stack = cause.getStackTrace()) {
            String className = element.getClassName();
            if (CrashAnalyzer.isMinecraftClass(className)) continue;
            Optional<ModContainer> mod = CrashAnalyzer.findModByClassName(className);
            mod.ifPresent(container -> {
                String modId = container.getMetadata().getId();
                if (CrashAnalyzer.isIgnoredMod(modId)) {
                    return;
                }
                int score = modScores.getOrDefault(container, 0) + 1;
                modScores.put(container, score);
            });
        }
        if (modScores.isEmpty()) {
            return null;
        }
        ModContainer topMod = (ModContainer)Collections.max(modScores.entrySet(), Map.Entry.comparingByValue()).getKey();
        String topClass = cause.getStackTrace()[0].getClassName();
        CrashCategory category = CrashAnalyzer.categorize(cause);
        return new CrashAnalysisResult(topMod, cause.getClass().getSimpleName(), topClass, category);
    }

    private static boolean isMinecraftClass(String className) {
        return className.startsWith("net.minecraft") || className.startsWith("java.") || className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("org.lwjgl") || className.startsWith("com.mojang");
    }

    private static boolean isIgnoredMod(String modId) {
        return IGNORED_MOD_IDS.contains(modId);
    }

    private static Optional<ModContainer> findModByClassName(String className) {
        String internalPath = className.replace('.', '/');
        return FabricLoader.getInstance().getAllMods().stream().filter(mod -> mod.getRootPaths().stream().anyMatch(path -> {
            try {
                return Files.walk(path, new FileVisitOption[0]).anyMatch(p -> p.toString().contains(internalPath));
            }
            catch (Exception e) {
                return false;
            }
        })).findFirst();
    }

    private static CrashCategory categorize(Throwable cause) {
        String name = cause.getClass().getSimpleName();
        if (name.contains("ClassNotFound") || name.contains("NoSuchMethod") || name.contains("NoSuchField")) {
            return CrashCategory.UPDATE_MOD;
        }
        if (name.contains("NullPointer") || name.contains("ArrayIndex") || name.contains("IllegalState")) {
            return CrashCategory.BUG_IN_MOD;
        }
        if (name.contains("Mixin") || name.contains("ClassCast") || name.contains("IncompatibleClassChange")) {
            return CrashCategory.MOD_CONFLICT;
        }
        return CrashCategory.UNKNOWN;
    }
}

