/*
 * Decompiled with CFR 0.152.
 */
package booftoo.dahud.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="dahud", value={Dist.CLIENT})
public class DahudOverlay {
    private static final ResourceLocation HUD_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/hud.png");
    private static final ResourceLocation SLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/slots.png");
    private static final ResourceLocation SLOT_HOVER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/slots_hover.png");
    private static final Map<MobEffect, ResourceLocation> EFFECT_ICONS = new HashMap<MobEffect, ResourceLocation>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "dahud_config.json");
    private static Config config = new Config();
    private static final int BORDER_LIMIT = 5;
    private static final KeyMapping EDIT_HUD_KEY = new KeyMapping("key.dahud.edit_hud", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 75, "Dahud HUD");

    private static void renderHud(GuiGraphics gui) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int x = Math.max(5, Math.min(DahudOverlay.config.hudX, screenWidth - 148 - 5));
        int y = Math.max(5, Math.min(DahudOverlay.config.hudY, screenHeight - 64 - 5));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HUD_BACKGROUND);
        gui.m_280163_(HUD_BACKGROUND, x, y, 0.0f, 0.0f, 148, 64, 148, 64);
        int barStartX = x + 67;
        int healthBarY = y + 27;
        int foodBarY = y + 32;
        int xpBarY = y + 40;
        ResourceLocation skin = player.m_108560_();
        int headX = barStartX - 38;
        int headY = foodBarY - 13;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)skin);
        RenderSystem.enableBlend();
        gui.m_280163_(skin, headX, headY, 8.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
        String playerName = player.m_7755_().getString();
        int nameWidth = mc.f_91062_.m_92895_(playerName);
        int nameX = barStartX + (65 - nameWidth) / 2;
        MutableComponent nameComponent = Component.m_237113_((String)playerName).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        gui.m_280614_(mc.f_91062_, (Component)nameComponent, nameX, y + 10, 12750684, false);
        float healthPercent = player.m_21223_() / player.m_21233_();
        int healthBarWidth = (int)(50.0f * healthPercent);
        gui.m_280509_(barStartX, healthBarY, barStartX + healthBarWidth, healthBarY + 4, -43691);
        float foodPercent = (float)player.m_36324_().m_38702_() / 20.0f;
        int foodBarWidth = (int)(50.0f * foodPercent);
        gui.m_280509_(barStartX, foodBarY, barStartX + foodBarWidth, foodBarY + 4, -22016);
        float xpPercent = player.f_36080_;
        int xpBarWidth = (int)(50.0f * xpPercent);
        gui.m_280509_(barStartX, xpBarY, barStartX + xpBarWidth, xpBarY + 4, -11141291);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
        gui.m_280056_(mc.f_91062_, String.format("%.0f%%", Float.valueOf(healthPercent * 100.0f)), (int)((float)(barStartX + 55) / 0.8f), (int)((float)healthBarY / 0.8f) - 2, -43691, false);
        gui.m_280056_(mc.f_91062_, String.format("%.0f%%", Float.valueOf(foodPercent * 100.0f)), (int)((float)(barStartX + 55) / 0.8f), (int)((float)foodBarY / 0.8f) - 2, -22016, false);
        gui.m_280168_().m_85849_();
        String xpLevel = String.valueOf(player.f_36078_);
        MutableComponent xpComponent = Component.m_237113_((String)xpLevel).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN));
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
        gui.m_280614_(mc.f_91062_, (Component)xpComponent, (int)((float)(barStartX + 55) / 0.8f), (int)((float)(xpBarY - 1) / 0.8f), -11141291, false);
        gui.m_280168_().m_85849_();
        int slotSize = 18;
        int slotSpacing = 3;
        int hotbarWidth = (slotSize + slotSpacing) * 9 - slotSpacing;
        int hotbarHeight = slotSize;
        int hotbarX = DahudOverlay.config.hotbarX == -1 ? (screenWidth - hotbarWidth) / 2 : Math.max(5, Math.min(DahudOverlay.config.hotbarX, screenWidth - hotbarWidth - 5));
        int hotbarY = DahudOverlay.config.hotbarY == -1 ? screenHeight - slotSize - 10 : Math.max(5, Math.min(DahudOverlay.config.hotbarY, screenHeight - hotbarHeight - 5));
        int selectedSlot = player.m_150109_().f_35977_;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            int slotX = hotbarX + i * (slotSize + slotSpacing);
            int slotY = hotbarY;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SLOT_TEXTURE);
            gui.m_280163_(SLOT_TEXTURE, slotX, slotY, 0.0f, 0.0f, slotSize, slotSize, slotSize, slotSize);
            if (i == selectedSlot) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SLOT_HOVER_TEXTURE);
                int hoverY = slotY - slotSize;
                gui.m_280163_(SLOT_HOVER_TEXTURE, slotX, hoverY, 0.0f, 0.0f, slotSize, slotSize, slotSize, slotSize);
            }
            if ((stack = (ItemStack)player.m_150109_().f_35974_.get(i)).m_41619_()) continue;
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
            gui.m_280480_(stack, (int)((float)(slotX + 3) / 0.75f), (int)((float)(slotY + 3) / 0.75f));
            gui.m_280370_(mc.f_91062_, stack, (int)((float)(slotX + 3) / 0.75f), (int)((float)(slotY + 3) / 0.75f));
            gui.m_280168_().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(EDIT_HUD_KEY);
    }

    @SubscribeEvent
    public static void onPreRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type() || event.getOverlay() == VanillaGuiOverlay.FOOD_LEVEL.type() || event.getOverlay() == VanillaGuiOverlay.HOTBAR.type() || event.getOverlay() == VanillaGuiOverlay.EXPERIENCE_BAR.type()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91080_ != null) {
            return;
        }
        DahudOverlay.renderHud(event.getGuiGraphics());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (EDIT_HUD_KEY.m_90859_() && !(mc.f_91080_ instanceof HudEditScreen)) {
            System.out.println("Key K pressed, opening HudEditScreen");
            mc.m_91152_((Screen)new HudEditScreen());
            mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"HUD Edit Mode Opened"), false);
        }
    }

    private static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    Minecraft mc = Minecraft.m_91087_();
                    int screenWidth = mc.m_91268_().m_85445_();
                    int screenHeight = mc.m_91268_().m_85446_();
                    DahudOverlay.config.hudX = Math.max(5, Math.min(loadedConfig.hudX, screenWidth - 148 - 5));
                    DahudOverlay.config.hudY = Math.max(5, Math.min(loadedConfig.hudY, screenHeight - 64 - 5));
                    DahudOverlay.config.hotbarX = loadedConfig.hotbarX == -1 ? -1 : Math.max(5, Math.min(loadedConfig.hotbarX, screenWidth - 189 + 3 - 5));
                    DahudOverlay.config.hotbarY = loadedConfig.hotbarY == -1 ? -1 : Math.max(5, Math.min(loadedConfig.hotbarY, screenHeight - 18 - 5));
                } else {
                    config = new Config();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                config = new Config();
            }
        } else {
            config = new Config();
            DahudOverlay.saveConfig();
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register(DahudOverlay.class);
    }

    static {
        EFFECT_ICONS.put(MobEffects.f_19596_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/speed.png"));
        EFFECT_ICONS.put(MobEffects.f_19607_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/fire.png"));
        EFFECT_ICONS.put(MobEffects.f_19606_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/shield.png"));
        EFFECT_ICONS.put(MobEffects.f_19603_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/jump.png"));
        EFFECT_ICONS.put(MobEffects.f_19610_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/blind.png"));
        EFFECT_ICONS.put(MobEffects.f_19614_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/poison.png"));
        EFFECT_ICONS.put(MobEffects.f_19609_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/invisibility.png"));
        EFFECT_ICONS.put(MobEffects.f_19605_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/heart.png"));
        EFFECT_ICONS.put(MobEffects.f_19612_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/food.png"));
        EFFECT_ICONS.put(MobEffects.f_19608_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/swimming.png"));
        EFFECT_ICONS.put(MobEffects.f_19600_, ResourceLocation.fromNamespaceAndPath((String)"dahud", (String)"textures/gui/strength.png"));
        DahudOverlay.loadConfig();
    }

    private static class Config {
        int hudX = 10;
        int hudY = 5;
        int hotbarX = -1;
        int hotbarY = -1;

        private Config() {
        }
    }

    public static class HudEditScreen
    extends Screen {
        private boolean isDraggingHud = false;
        private boolean isDraggingHotbar = false;
        private int dragOffsetX;
        private int dragOffsetY;

        protected HudEditScreen() {
            super((Component)Component.m_237113_((String)"Dahud HUD Editor"));
        }

        protected void m_7856_() {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), button -> {
                DahudOverlay.saveConfig();
                this.f_96541_.m_91152_(null);
            }).m_252987_(this.f_96543_ - 100, 10, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ - 100, 40, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), button -> {
                DahudOverlay.config.hudX = 10;
                DahudOverlay.config.hudY = 5;
                DahudOverlay.config.hotbarX = -1;
                DahudOverlay.config.hotbarY = -1;
                DahudOverlay.saveConfig();
            }).m_252987_(this.f_96543_ - 100, 70, 80, 20).m_253136_());
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            DahudOverlay.renderHud(guiGraphics);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int hotbarY;
            int screenWidth = this.f_96541_.m_91268_().m_85445_();
            int screenHeight = this.f_96541_.m_91268_().m_85446_();
            if (mouseX >= (double)DahudOverlay.config.hudX && mouseX <= (double)(DahudOverlay.config.hudX + 148) && mouseY >= (double)DahudOverlay.config.hudY && mouseY <= (double)(DahudOverlay.config.hudY + 64)) {
                this.isDraggingHud = true;
                this.dragOffsetX = (int)(mouseX - (double)DahudOverlay.config.hudX);
                int dragOffsetY = (int)(mouseY - (double)DahudOverlay.config.hudY);
                return true;
            }
            int hotbarWidth = 186;
            int hotbarHeight = 18;
            int hotbarX = DahudOverlay.config.hotbarX == -1 ? (screenWidth - hotbarWidth) / 2 : DahudOverlay.config.hotbarX;
            int n = hotbarY = DahudOverlay.config.hotbarY == -1 ? screenHeight - 28 : DahudOverlay.config.hotbarY;
            if (mouseX >= (double)hotbarX && mouseX <= (double)(hotbarX + hotbarWidth) && mouseY >= (double)hotbarY && mouseY <= (double)(hotbarY + hotbarHeight)) {
                this.isDraggingHotbar = true;
                this.dragOffsetX = (int)(mouseX - (double)hotbarX);
                this.dragOffsetY = (int)(mouseY - (double)hotbarY);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDraggingHud = false;
            this.isDraggingHotbar = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            int screenWidth = this.f_96541_.m_91268_().m_85445_();
            int screenHeight = this.f_96541_.m_91268_().m_85446_();
            if (this.isDraggingHud) {
                DahudOverlay.config.hudX = Math.max(5, Math.min((int)(mouseX - (double)this.dragOffsetX), screenWidth - 148 - 5));
                DahudOverlay.config.hudY = Math.max(5, Math.min((int)(mouseY - (double)this.dragOffsetY), screenHeight - 64 - 5));
                return true;
            }
            if (this.isDraggingHotbar) {
                DahudOverlay.config.hotbarX = Math.max(5, Math.min((int)(mouseX - (double)this.dragOffsetX), screenWidth - 189 + 3 - 5));
                DahudOverlay.config.hotbarY = Math.max(5, Math.min((int)(mouseY - (double)this.dragOffsetY), screenHeight - 18 - 5));
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean m_7043_() {
            return true;
        }
    }
}

