/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.platform;

import it.crystalnest.cobweb.api.pack.PackSources;
import it.crystalnest.cobweb.api.pack.fixed.StaticResourcePack;
import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.api.registry.Register;
import it.crystalnest.cobweb.api.registry.RegisterProvider;
import it.crystalnest.cobweb.platform.services.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public final class FabricRegistryHelper
extends RegistryHelper<DeferredRegister<?>> {
    private static final List<Supplier<class_3288>> DYNAMIC_DATA_PACKS = new ArrayList<Supplier<class_3288>>();
    private static final List<Supplier<class_3288>> DYNAMIC_TEXTURE_PACKS = new ArrayList<Supplier<class_3288>>();
    private static final List<StaticResourcePack> STATIC_DATA_PACKS = new ArrayList<StaticResourcePack>();
    private static final List<StaticResourcePack> STATIC_TEXTURE_PACKS = new ArrayList<StaticResourcePack>();

    public static class_3283 registerDataPacks(class_3283 repository) {
        FabricRegistryHelper.registerDynamicPacks(DYNAMIC_DATA_PACKS, repository);
        FabricRegistryHelper.registerStaticPacks(STATIC_DATA_PACKS, repository);
        return repository;
    }

    public static class_3283 registerTexturePacks(class_3283 repository) {
        FabricRegistryHelper.registerDynamicPacks(DYNAMIC_TEXTURE_PACKS, repository);
        FabricRegistryHelper.registerStaticPacks(STATIC_TEXTURE_PACKS, repository);
        return repository;
    }

    private static void registerDynamicPacks(List<Supplier<class_3288>> packs, class_3283 repository) {
        FabricRegistryHelper.registerPacks(packs, Supplier::get, repository);
    }

    private static void registerStaticPacks(List<StaticResourcePack> packs, class_3283 repository) {
        FabricRegistryHelper.registerPacks(packs, StaticResourcePack::toPack, repository);
    }

    private static <T> void registerPacks(List<T> packs, Function<T, class_3288> toPack, class_3283 repository) {
        packs.stream().map(toPack).forEach(pack -> ((PackSources)repository).addSource(packConsumer -> packConsumer.accept(pack)));
    }

    @Override
    public <R> DeferredRegister<R> of(class_5321<? extends class_2378<R>> registryKey, String namespace) {
        return this.of(id -> new DeferredRegister(registryKey, (String)id), registryKey, namespace);
    }

    @Override
    public CobwebRegister.Items ofItems(String namespace) {
        return this.of(DeferredRegister.Items::new, class_7924.field_41197, namespace);
    }

    @Override
    public CobwebRegister.Blocks ofBlocks(String namespace) {
        return this.of(DeferredRegister.Blocks::new, class_7924.field_41254, namespace);
    }

    @Override
    public void registerDynamicResourcePack(class_3264 type, Supplier<class_3288> supplier) {
        switch (type) {
            case field_14190: {
                DYNAMIC_DATA_PACKS.add(supplier);
                break;
            }
            case field_14188: {
                DYNAMIC_TEXTURE_PACKS.add(supplier);
            }
        }
    }

    @Override
    public void registerStaticResourcePack(StaticResourcePack pack) {
        switch (pack.type()) {
            case field_14190: {
                STATIC_DATA_PACKS.add(pack);
                break;
            }
            case field_14188: {
                STATIC_TEXTURE_PACKS.add(pack);
            }
        }
    }

    private <R, T extends DeferredRegister<R>> T of(Function<String, T> constructor, class_5321<? extends class_2378<R>> registryKey, String namespace) {
        return (T)this.registries.computeIfAbsent(namespace, key -> new HashMap()).computeIfAbsent(registryKey.method_29177(), key -> (DeferredRegister)constructor.apply(namespace));
    }

    public static class DeferredRegister<R>
    implements CobwebRegister<R> {
        private final Register<R> register;
        private final String namespace;

        private DeferredRegister(class_5321<? extends class_2378<R>> registryKey, String namespace) {
            this.register = new RegisterProvider(namespace).of(registryKey);
            this.namespace = namespace;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public <T extends R> CobwebEntry<T> register(String name, Supplier<? extends T> supplier) {
            return new CobwebEntry(class_6880.method_40223(this.register.apply(name, supplier.get())));
        }

        public static final class Blocks
        extends DeferredRegister<class_2248>
        implements CobwebRegister.Blocks {
            private Blocks(String namespace) {
                super(class_7924.field_41254, namespace);
            }
        }

        public static final class Items
        extends DeferredRegister<class_1792>
        implements CobwebRegister.Items {
            private Items(String namespace) {
                super(class_7924.field_41197, namespace);
            }
        }
    }
}

