/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.platform;

import it.crystalnest.cobweb.api.pack.fixed.StaticResourcePack;
import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.platform.services.RegistryHelper;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NeoForgeRegistryHelper
extends RegistryHelper<Register<?>> {
    private IEventBus bus = null;

    @Override
    public <R> Register<R> of(ResourceKey<? extends Registry<R>> registryKey, String namespace) {
        return this.of(id -> new Register(registryKey, (String)id), registryKey, namespace);
    }

    @Override
    public CobwebRegister.Items ofItems(String namespace) {
        return this.of(Register.Items::new, Registries.ITEM, namespace);
    }

    @Override
    public CobwebRegister.Blocks ofBlocks(String namespace) {
        return this.of(Register.Blocks::new, Registries.BLOCK, namespace);
    }

    @Override
    public void registerDynamicResourcePack(PackType type, Supplier<Pack> supplier) {
        this.bus.addListener(event -> {
            if (event.getPackType() == type) {
                event.addRepositorySource(arg_0 -> NeoForgeRegistryHelper.lambda$registerDynamicResourcePack$1((Supplier)supplier, arg_0));
            }
        });
    }

    @Override
    public void registerStaticResourcePack(StaticResourcePack pack) {
        this.bus.addListener(event -> event.addPackFinders(pack.location(), pack.type(), pack.name(), pack.source(), pack.alwaysActive(), pack.position()));
    }

    private <R, T extends Register<R>> T of(Function<String, T> constructor, ResourceKey<? extends Registry<R>> registryKey, String namespace) {
        return (T)this.registries.computeIfAbsent(namespace, key -> new HashMap()).computeIfAbsent(registryKey.location(), key -> {
            Register register = (Register)constructor.apply(namespace);
            register.register(this.bus);
            return register;
        });
    }

    public void register(IEventBus bus) {
        this.bus = bus;
    }

    private static /* synthetic */ void lambda$registerDynamicResourcePack$1(Supplier supplier, Consumer consumer) {
        consumer.accept((Pack)supplier.get());
    }

    public static class Register<R>
    implements CobwebRegister<R> {
        private final DeferredRegister<R> register;
        private final String namespace;

        private Register(ResourceKey<? extends Registry<R>> registryKey, String namespace) {
            this.register = DeferredRegister.create(registryKey, (String)namespace);
            this.namespace = namespace;
        }

        public void register(IEventBus bus) {
            this.register.register(bus);
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public <T extends R> CobwebEntry<T> register(String name, Supplier<? extends T> supplier) {
            return new CobwebEntry(this.register.register(name, supplier));
        }

        public static final class Blocks
        extends Register<Block>
        implements CobwebRegister.Blocks {
            private Blocks(String namespace) {
                super(Registries.BLOCK, namespace);
            }
        }

        public static final class Items
        extends Register<Item>
        implements CobwebRegister.Items {
            private Items(String namespace) {
                super(Registries.ITEM, namespace);
            }
        }
    }
}

