/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.registry;

import it.crystalnest.cobweb.api.registry.CobwebEntry;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public interface CobwebRegister<R> {
    public String namespace();

    public <T extends R> CobwebEntry<T> register(String var1, Supplier<? extends T> var2);

    public static interface Blocks
    extends CobwebRegister<Block> {
        default public <T extends Block> CobwebEntry<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> supplier) {
            return this.register(name, () -> (Block)supplier.apply(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace(), (String)name)))));
        }
    }

    public static interface Items
    extends CobwebRegister<Item> {
        default public <T extends Item> CobwebEntry<T> registerItem(String name, Function<Item.Properties, T> supplier) {
            return this.register(name, () -> (Item)supplier.apply(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace(), (String)name)))));
        }

        default public <T extends BlockItem, B extends Block> CobwebEntry<T> registerBlockItemLike(String name, Supplier<B> block, Item.Properties properties, BiFunction<B, Item.Properties, T> constructor) {
            return this.register(name, () -> (BlockItem)constructor.apply((Block)block.get(), properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace(), (String)name))).useBlockDescriptionPrefix()));
        }

        default public CobwebEntry<BlockItem> registerBlockItem(String name, Supplier<? extends Block> block, Item.Properties properties) {
            return this.registerBlockItemLike(name, block, properties, BlockItem::new);
        }

        default public CobwebEntry<BlockItem> registerBlockItem(String name, Supplier<? extends Block> block) {
            return this.registerBlockItem(name, block, new Item.Properties());
        }
    }
}

