/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.pack.dynamic;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.crystalnest.cobweb.api.pack.dynamic.DynamicResourceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class DynamicTagBuilder<T>
extends TagBuilder {
    private final Set<String> keys = new HashSet<String>();
    private final List<ResourceLocation> tags;
    private final Registry<T> registry;

    private DynamicTagBuilder(Registry<T> registry, List<ResourceLocation> tags) {
        this.tags = tags;
        this.registry = registry;
    }

    @SafeVarargs
    public static <R> DynamicTagBuilder<R> of(Registry<R> registry, TagKey<? extends R> ... tags) {
        return new DynamicTagBuilder<R>(registry, Arrays.stream(tags).map(TagKey::location).toList());
    }

    @SafeVarargs
    public static <R> DynamicTagBuilder<R> of(ResourceKey<? extends Registry<R>> registryKey, TagKey<? extends R> ... tags) {
        return DynamicTagBuilder.of((Registry)((Holder.Reference)BuiltInRegistries.REGISTRY.get(registryKey.location()).orElseThrow()).value(), tags);
    }

    public List<ResourceLocation> getTags() {
        return this.tags;
    }

    public List<ResourceLocation> getPaths() {
        return this.getTags().stream().map(tag -> DynamicResourceType.TAG.getPath(ResourceLocation.fromNamespaceAndPath((String)tag.getNamespace(), (String)(this.registry.key().location().getPath() + "/" + tag.getPath())))).toList();
    }

    @NotNull
    public DynamicTagBuilder<T> add(@NotNull TagEntry entry) {
        if (this.keys.add(entry.toString())) {
            return (DynamicTagBuilder)super.add(entry);
        }
        return this;
    }

    public DynamicTagBuilder<T> addTag(TagKey<? extends T> tagKey) {
        return (DynamicTagBuilder)this.addTag(tagKey.location());
    }

    public DynamicTagBuilder<T> addElement(T element) {
        return (DynamicTagBuilder)this.addElement(Objects.requireNonNull(this.registry.getKey(element)));
    }

    public DynamicTagBuilder<T> addElements(Collection<? extends T> elements) {
        for (T element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public DynamicTagBuilder<T> addElements(T ... elements) {
        for (T element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public JsonElement json() {
        return (JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(this.build(), false)).getOrThrow();
    }
}

