/*
 * Decompiled with CFR 0.152.
 */
package com.yzf.screen;

import com.yzf.KeyPreset;
import com.yzf.KeyPresetManager;
import com.yzf.mixin.KeyBindsScreenAccessor;
import com.yzf.screen.component.PresetList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class PresetScreen
extends Screen {
    private Screen parent;
    private KeyBindsList keyBindsList;
    private PresetList presetList;
    private Component editBoxText;
    private int editBoxTextColor;
    private EditBox editBox;
    private Button loadButton;
    private Button deleteButton;
    private Button saveButton;
    private Button openFolderButton;
    private Button doneButton;

    public PresetScreen(Screen parent) {
        super((Component)KeyPreset.TITLE);
        this.parent = parent;
        this.editBoxText = KeyPreset.ENTER_TEXT;
        this.editBoxTextColor = 0xFFFFFF;
    }

    protected void init() {
        super.init();
        this.initElement();
    }

    private void initElement() {
        this.presetList = new PresetList(Minecraft.getInstance(), (int)((double)this.width * 0.5), (int)((double)this.height * 0.7), (int)((double)this.height * 0.1), 20);
        this.editBox = new EditBox(this.font, (int)((double)this.width * 0.75 - (double)this.width * 0.2), (int)((double)this.height * 0.5 - (double)this.height * 0.025), (int)((double)this.width * 0.4), (int)((double)this.height * 0.05), (Component)Component.literal((String)""));
        this.editBox.setResponder(text -> {
            if (text.isBlank()) {
                this.editBoxText = KeyPreset.BLANK_TEXT;
                this.editBoxTextColor = 0xFB4B4B;
                this.editBox.setTextColor(0xFFFFFF);
                this.saveButton.active = false;
            } else if (KeyPreset.FORBIDDEN_CHARS.matcher((CharSequence)text).find()) {
                this.editBoxText = KeyPreset.FORBID_CHAR_TEXT;
                this.editBoxTextColor = 0xFB4B4B;
                this.editBox.setTextColor(this.editBoxTextColor);
                this.saveButton.active = false;
            } else if (this.isExist((String)text)) {
                this.editBoxText = KeyPreset.EXIST_TEXT;
                this.editBoxTextColor = 0xFB4B4B;
                this.editBox.setTextColor(this.editBoxTextColor);
                this.saveButton.active = false;
            } else {
                this.editBoxText = KeyPreset.VALID_TEXT;
                this.editBoxTextColor = 3669310;
                this.editBox.setTextColor(0xFFFFFF);
                this.saveButton.active = true;
            }
        });
        this.loadButton = Button.builder((Component)KeyPreset.LOAD, button -> {
            if (!KeyPreset.PRESET_FOLDER.resolve(((PresetList.PresetListEntry)this.presetList.getSelected()).text.getString() + ".json").toFile().exists()) {
                this.presetList.reload();
                return;
            }
            KeyPresetManager.loadPreset(((PresetList.PresetListEntry)this.presetList.getSelected()).text.getString());
            Minecraft.getInstance().setScreen(this.parent);
            if (Minecraft.getInstance().screen instanceof KeyBindsScreen) {
                ((KeyBindsScreenAccessor)Minecraft.getInstance().screen).getControlsListWidget().refreshEntries();
            }
        }).size((int)((double)this.width * 0.2), (int)((double)this.height * 0.05)).pos((int)((double)this.width * 0.375 - (double)this.width * 0.1), (int)((double)this.height * 0.85)).build();
        this.loadButton.active = false;
        this.deleteButton = Button.builder((Component)KeyPreset.DELETE, button -> {
            if (!KeyPreset.PRESET_FOLDER.resolve(((PresetList.PresetListEntry)this.presetList.getSelected()).text.getString() + ".json").toFile().exists()) {
                this.presetList.reload();
                return;
            }
            KeyPresetManager.deletePreset(((PresetList.PresetListEntry)this.presetList.getSelected()).text.getString());
            this.presetList.reload();
        }).size((int)((double)this.width * 0.2), (int)((double)this.height * 0.05)).pos((int)((double)this.width * 0.125 - (double)this.width * 0.1), (int)((double)this.height * 0.85)).build();
        this.deleteButton.active = false;
        this.saveButton = Button.builder((Component)KeyPreset.SAVE, button -> {
            KeyPresetManager.savePreset(this.editBox.getValue());
            this.saveButton.active = false;
            this.editBox.setValue("");
            this.presetList.reload();
        }).size((int)((double)this.width * 0.15), (int)((double)this.height * 0.05)).pos((int)((double)this.width * 0.75 - (double)this.width * 0.075), (int)((double)this.height * 0.5 + (double)this.height * 0.05)).build();
        this.saveButton.active = false;
        this.openFolderButton = Button.builder((Component)Component.literal((String)"..."), button -> KeyPresetManager.openPresetFolder()).size((int)((double)this.width * 0.05), (int)((double)this.height * 0.05)).pos((int)((double)this.width * 0.5), (int)((double)this.height * 0.85)).tooltip(Tooltip.create((Component)KeyPreset.OPEN_FOLDER_TOOLTIP)).build();
        this.doneButton = Button.builder((Component)KeyPreset.DONE, button -> Minecraft.getInstance().setScreen(this.parent)).size((int)((double)this.width * 0.2), (int)((double)this.height * 0.05)).pos((int)((double)this.width * 0.75 - (double)this.width * 0.1), (int)((double)this.height * 0.85)).build();
        this.addRenderableWidget((GuiEventListener)this.presetList);
        this.addRenderableWidget((GuiEventListener)this.editBox);
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.addRenderableWidget((GuiEventListener)this.loadButton);
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        this.addRenderableWidget((GuiEventListener)this.openFolderButton);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
    }

    public boolean isExist(String text) {
        for (String fileName : KeyPresetManager.getPresets()) {
            if (!fileName.toLowerCase().equals(text.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.drawString(this.font, (Component)KeyPreset.TITLE, (this.width - this.font.width((FormattedText)KeyPreset.TITLE)) / 2, (int)((double)this.height * 0.03), 0xFFFFFF, true);
        guiGraphics.drawString(this.font, this.editBoxText, (int)((double)this.width * 0.75 - (double)this.font.width((FormattedText)this.editBoxText) / 2.0), (int)((double)this.height * 0.5 - (double)this.height * 0.1), this.editBoxTextColor, true);
        if (this.presetList.getSelected() == null) {
            this.deleteButton.active = false;
            this.loadButton.active = false;
        } else {
            this.deleteButton.active = true;
            this.loadButton.active = true;
        }
        if (!this.openFolderButton.isHovered()) {
            this.openFolderButton.setFocused(false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickedOnEditBox = this.editBox.mouseClicked(mouseX, mouseY, button);
        if (!clickedOnEditBox && this.editBox.isFocused()) {
            this.editBox.setFocused(false);
            if (this.editBox.getValue().isBlank()) {
                this.editBox.setValue("");
                this.editBoxText = KeyPreset.ENTER_TEXT;
                this.editBoxTextColor = 0xFFFFFF;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

