/*
 * Decompiled with CFR 0.152.
 */
package com.yzf.screen.component;

import com.yzf.KeyPresetManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class PresetList
extends ObjectSelectionList<PresetListEntry> {
    public PresetList(Minecraft mc, int width, int height, int topMargin, int EntryHeight) {
        super(mc, width, height, topMargin, EntryHeight);
        this.addOption();
    }

    public void addOption() {
        for (String preset : KeyPresetManager.getPresets()) {
            this.addEntry((AbstractSelectionList.Entry)new PresetListEntry((Component)Component.literal((String)preset)));
        }
    }

    public void reload() {
        this.clearEntries();
        this.addOption();
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public int getRowWidth() {
        return this.width - 30;
    }

    public static class PresetListEntry
    extends ObjectSelectionList.Entry<PresetListEntry> {
        public final Component text;

        PresetListEntry(Component text) {
            this.text = text;
        }

        @NotNull
        public Component getNarration() {
            return this.text;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.text, left + width / 2, top + 4, !hovered && !this.isFocused() ? 0x6B6B6B : 0xFFFFFF);
        }
    }
}

