/*
 * Decompiled with CFR 0.152.
 */
package com.yzf;

import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.InputConstants;
import com.yzf.KeyPreset;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.spongepowered.include.com.google.gson.Gson;
import org.spongepowered.include.com.google.gson.GsonBuilder;
import org.spongepowered.include.com.google.gson.stream.JsonReader;

public class KeyPresetManager {
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void savePreset(String name) {
        KeyPresetManager.createPresetFolder();
        LinkedHashMap<String, String> keyBindsMap = new LinkedHashMap<String, String>();
        for (KeyMapping keyMappings : Minecraft.getInstance().options.keyMappings) {
            String key = keyMappings.getName();
            String value = keyMappings.getKey().toString();
            keyBindsMap.put(key, value);
        }
        try (FileWriter writer = new FileWriter(KeyPreset.PRESET_FOLDER.resolve(name + ".json").toString());){
            gson.toJson(keyBindsMap, (Appendable)writer);
        }
        catch (IOException e) {
            KeyPreset.LOGGER.error(e.getMessage());
        }
    }

    public static void deletePreset(String name) {
        KeyPresetManager.createPresetFolder();
        try {
            Files.delete(KeyPreset.PRESET_FOLDER.resolve(name + ".json"));
        }
        catch (IOException e) {
            KeyPreset.LOGGER.error(e.getMessage());
        }
    }

    public static void loadPreset(String name) {
        KeyPresetManager.createPresetFolder();
        try (FileReader reader = new FileReader(KeyPreset.PRESET_FOLDER.resolve(name + ".json").toFile());){
            Type linkedHashMapType = new TypeToken<LinkedHashMap<String, String>>(){}.getType();
            LinkedHashMap keyBindsMap = (LinkedHashMap)gson.fromJson(new JsonReader((Reader)reader), linkedHashMapType);
            for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
                String key = keyMapping.getName();
                if (!keyBindsMap.containsKey(key)) continue;
                String value = (String)keyBindsMap.get(key);
                InputConstants.Key newKey = InputConstants.getKey((String)value);
                keyMapping.setKey(newKey);
            }
            Minecraft.getInstance().options.save();
        }
        catch (Exception e) {
            KeyPreset.LOGGER.error(e.getMessage());
        }
    }

    public static void openPresetFolder() {
        KeyPresetManager.createPresetFolder();
        String os = System.getProperty("os.name").toLowerCase();
        ProcessBuilder pb = null;
        if (os.contains("windows")) {
            pb = new ProcessBuilder("explorer", KeyPreset.PRESET_FOLDER.toAbsolutePath().toString());
        } else if (os.contains("mac")) {
            pb = new ProcessBuilder("open", KeyPreset.PRESET_FOLDER.toAbsolutePath().toString());
        } else if (os.contains("linux")) {
            pb = new ProcessBuilder("xdg-open", KeyPreset.PRESET_FOLDER.toAbsolutePath().toString());
        } else if (os.contains("unix")) {
            pb = new ProcessBuilder("xdg-open", KeyPreset.PRESET_FOLDER.toAbsolutePath().toString());
        }
        try {
            if (pb != null) {
                pb.start();
            }
        }
        catch (IOException e) {
            KeyPreset.LOGGER.error(e.getMessage());
        }
    }

    public static String[] getPresets() {
        String[] stringArray;
        block8: {
            KeyPresetManager.createPresetFolder();
            Stream<Path> stream = Files.list(KeyPreset.PRESET_FOLDER);
            try {
                stringArray = (String[])stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                    String fileName = p.getFileName().toString();
                    return fileName.endsWith(".json");
                }).map(p -> {
                    String fullName = p.getFileName().toString();
                    return fullName.substring(0, fullName.lastIndexOf(".json"));
                }).toArray(String[]::new);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    KeyPreset.LOGGER.error(e.getMessage());
                    return new String[0];
                }
            }
            stream.close();
        }
        return stringArray;
    }

    public static void createPresetFolder() {
        try {
            Files.createDirectories(KeyPreset.PRESET_FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            KeyPreset.LOGGER.error(e.getMessage());
        }
    }
}

