/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.solomonsrod;

import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2311;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2526;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.item.EnchantableArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.HandUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemGroups;
import net.pitan76.solomonsrod.Config;
import net.pitan76.solomonsrod.SolomonsBlock;
import net.pitan76.solomonsrod.SolomonsRod;
import net.pitan76.solomonsrod.Sounds;

public class SolomonsWand
extends CompatItem {
    public static SolomonsWand SOLOMONS_WAND = SolomonsWand.of(SolomonsRod._id("solomon_wand"));

    public SolomonsWand(CompatibleItemSettings settings) {
        super(settings);
    }

    public static SolomonsWand of(CompatIdentifier id) {
        CompatibleItemSettings settings = CompatibleItemSettings.of((CompatIdentifier)id).addGroup(ItemGroups.TOOLS).enchantable(15);
        if (!Config.infiniteDurability) {
            settings.maxDamage(Config.maxDamage);
        } else {
            settings.maxCount(1);
        }
        return new SolomonsWand(settings);
    }

    public void deleteBlock(class_1937 world, Player user, class_2338 pos) {
        WorldUtil.removeBlock((class_1937)world, (class_2338)pos, (boolean)false);
        WorldUtil.playSound((class_1937)world, null, (class_2338)user.getBlockPos(), (CompatSoundEvent)Sounds.ERASE_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
    }

    public CompatActionResult onRightClickOnBlock(ItemUseOnBlockEvent e) {
        class_1937 world = e.world;
        class_2338 blockPos = PosUtil.flooredBlockPos((class_243)e.getPos());
        if (!Config.infiniteDurability && ItemStackUtil.isBreak((class_1799)e.stack)) {
            return super.onRightClickOnBlock(e);
        }
        if (e.isClient()) {
            if (WorldUtil.canSetBlock((class_1937)world, (class_2338)blockPos) && SolomonsWand.canPlace(WorldUtil.getBlockState((class_1937)world, (class_2338)blockPos).method_26204())) {
                return e.success();
            }
            return super.onRightClickOnBlock(e);
        }
        if (!WorldUtil.canSetBlock((class_1937)world, (class_2338)blockPos) || !SolomonsWand.canPlace(WorldUtil.getBlockState((class_1937)world, (class_2338)blockPos).method_26204())) {
            return super.onRightClickOnBlock(e);
        }
        if (WorldUtil.getBlockEntity((class_1937)world, (class_2338)blockPos) != null) {
            WorldUtil.playSound((class_1937)world, null, (class_2338)e.player.getBlockPos(), (CompatSoundEvent)Sounds.NOCRASH_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
            return e.success();
        }
        WorldUtil.setBlockState((class_1937)world, (class_2338)blockPos, (class_2680)BlockStateUtil.getDefaultState((class_2248)SolomonsBlock.SOLOMONS_BLOCK));
        WorldUtil.playSound((class_1937)world, null, (class_2338)blockPos, (CompatSoundEvent)Sounds.CREATE_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
        SolomonsWand.damageStackIfDamageable(e.player.getStackInHand(e.hand), e.player, e.hand);
        return e.success();
    }

    public StackActionResult onRightClick(ItemUseEvent e) {
        Player user;
        class_2338 blockPos;
        class_1937 world;
        if (!Config.infiniteDurability && ItemStackUtil.isBreak((class_1799)e.stack)) {
            return super.onRightClick(e);
        }
        if (e.isClient()) {
            super.onRightClick(e);
        }
        if (WorldUtil.canSetBlock((class_1937)(world = e.world), (class_2338)(blockPos = SolomonsWand.getPlacingPos(user = e.user))) && SolomonsWand.canPlace(WorldUtil.getBlockState((class_1937)world, (class_2338)blockPos).method_26204()) && WorldUtil.getBlockEntity((class_1937)world, (class_2338)blockPos) == null) {
            WorldUtil.setBlockState((class_1937)world, (class_2338)blockPos, (class_2680)BlockStateUtil.getDefaultState((class_2248)SolomonsBlock.SOLOMONS_BLOCK));
            WorldUtil.playSound((class_1937)world, null, (class_2338)user.getBlockPos(), (CompatSoundEvent)Sounds.CREATE_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
            SolomonsWand.damageStackIfDamageable(e.stack, user, e.hand);
            return e.success();
        }
        return super.onRightClick(e);
    }

    public static void damageStackIfDamageable(class_1799 stack, Player player, class_1268 hand) {
        if (!Config.infiniteDurability) {
            Optional optionalServerPlayer = player.getServerPlayer();
            if (!optionalServerPlayer.isPresent()) {
                return;
            }
            class_3222 serverPlayer = (class_3222)optionalServerPlayer.get();
            ItemStackUtil.damage((class_1799)stack, (int)1, (class_1309)serverPlayer, (class_1304)HandUtil.getEquipmentSlot((class_1268)hand));
        }
    }

    public static class_2338 getPlacingPos(Player user) {
        class_243 pos = user.getPos();
        double posX = pos.method_10216();
        double posY = pos.method_10214();
        double posZ = pos.method_10215();
        boolean notChange = false;
        if (user.getPitch() <= -25.0f) {
            posY += 2.0;
            if (user.getPitch() <= -60.0f && user.getPitch() >= -90.0f) {
                notChange = true;
            }
        }
        if (user.getPitch() <= 25.0f && user.getPitch() >= -25.0f) {
            posY += 1.0;
        }
        if (user.getPitch() >= 50.0f) {
            posY -= 1.0;
            if (user.getPitch() <= 90.0f && user.getPitch() >= 75.0f) {
                notChange = true;
            }
        }
        if (!notChange) {
            if (user.getHorizontalFacing() == class_2350.field_11034) {
                posX += 1.0;
            }
            if (user.getHorizontalFacing() == class_2350.field_11039) {
                posX -= 1.0;
            }
            if (user.getHorizontalFacing() == class_2350.field_11043) {
                posZ -= 1.0;
            }
            if (user.getHorizontalFacing() == class_2350.field_11035) {
                posZ += 1.0;
            }
        }
        return PosUtil.flooredBlockPos((double)posX, (double)posY, (double)posZ);
    }

    public static boolean canPlace(class_2248 block) {
        if (block == null) {
            return true;
        }
        if (block instanceof class_2189) {
            return true;
        }
        if (block instanceof class_2404) {
            return true;
        }
        if (block instanceof class_2526) {
            return true;
        }
        return block instanceof class_2311;
    }

    public boolean isEnchantable(EnchantableArgs args) {
        return true;
    }
}

