/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.solomonsrod;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.pitan76.mcpitanlib.api.block.CompatibleMaterial;
import net.pitan76.mcpitanlib.api.block.args.v2.CollisionShapeEvent;
import net.pitan76.mcpitanlib.api.block.args.v2.OutlineShapeEvent;
import net.pitan76.mcpitanlib.api.block.v2.CompatBlock;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.event.block.BlockBreakStartEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockScheduledTickEvent;
import net.pitan76.mcpitanlib.api.event.block.EntityCollisionEvent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.PropertyUtil;
import net.pitan76.mcpitanlib.api.util.VoxelShapeUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.core.serialization.CompatMapCodec;
import net.pitan76.solomonsrod.DemonsWand;
import net.pitan76.solomonsrod.SolomonsRod;
import net.pitan76.solomonsrod.SolomonsWand;
import net.pitan76.solomonsrod.Sounds;

public class SolomonsBlock
extends CompatBlock {
    public static final CompatMapCodec<? extends SolomonsBlock> CODEC = CompatMapCodec.createCodecOfCompatBlock(SolomonsBlock::new);
    protected static final VoxelShape SHAPE = VoxelShapeUtil.blockCuboid((double)0.1, (double)0.1, (double)0.1, (double)15.5, (double)16.0, (double)15.5);
    public static final BooleanProperty BROKEN = PropertyUtil.createBooleanProperty((String)"broken");
    public static final BooleanProperty COOL_DOWN = PropertyUtil.createBooleanProperty((String)"cooldown");
    public static CompatibleBlockSettings settings = CompatibleBlockSettings.of((CompatIdentifier)SolomonsRod._id("solomon_block"), (CompatibleMaterial)CompatibleMaterial.METAL).strength(-1.0f, 0.0f).dropsNothing();
    public static SolomonsBlock SOLOMONS_BLOCK = new SolomonsBlock(settings);

    public CompatMapCodec<? extends SolomonsBlock> getCompatCodec() {
        return CODEC;
    }

    public SolomonsBlock(CompatibleBlockSettings settings) {
        super(settings);
        this.setDefaultState(this.getDefaultMidohraState().with((Property)BROKEN, (Comparable)Boolean.valueOf(false)).with((Property)COOL_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public void appendProperties(AppendPropertiesArgs args) {
        super.appendProperties(args);
        args.addProperty(new Property[]{BROKEN});
        args.addProperty(new Property[]{COOL_DOWN});
    }

    public VoxelShape getOutlineShape(OutlineShapeEvent e) {
        return VoxelShapeUtil.fullCube();
    }

    public VoxelShape getCollisionShape(CollisionShapeEvent e) {
        return SHAPE;
    }

    public void scheduledTick(BlockScheduledTickEvent e) {
        WorldUtil.setBlockState((Level)e.world, (BlockPos)e.pos, (BlockState)BlockStateUtil.with((BlockState)e.state, (Property)COOL_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public void onEntityCollision(EntityCollisionEvent e) {
        Player player;
        BlockPos cameraPos;
        if (e.isClient()) {
            return;
        }
        Level world = e.getWorld();
        BlockPos pos = e.getBlockPos();
        net.pitan76.mcpitanlib.midohra.block.BlockState state = net.pitan76.mcpitanlib.midohra.block.BlockState.of((BlockState)e.getState());
        if (e.getEntityPos().equals((Object)pos)) {
            WorldUtil.playSound((Level)e.getWorld(), null, (BlockPos)e.getEntityPos(), (CompatSoundEvent)Sounds.NOCRASH_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
            WorldUtil.removeBlock((Level)e.getWorld(), (BlockPos)pos, (boolean)false);
            return;
        }
        if (e.getEntity() instanceof Player && PosUtil.y((BlockPos)(cameraPos = PosUtil.flooredBlockPos((Vec3)(player = (Player)e.getEntity()).m_20299_(1.0f)))) >= PosUtil.y((BlockPos)pos)) {
            return;
        }
        if (!((Boolean)state.get((Property)COOL_DOWN)).booleanValue()) {
            if (((Boolean)state.get((Property)BROKEN)).booleanValue()) {
                WorldUtil.removeBlock((Level)world, (BlockPos)pos, (boolean)false);
            } else {
                WorldUtil.scheduleBlockTick((Level)world, (BlockPos)pos, (Block)SOLOMONS_BLOCK, (int)5);
                WorldUtil.setBlockState((Level)world, (BlockPos)pos, (net.pitan76.mcpitanlib.midohra.block.BlockState)state.with((Property)BROKEN, (Comparable)Boolean.valueOf(true)).with((Property)COOL_DOWN, (Comparable)Boolean.valueOf(true)));
            }
            WorldUtil.playSound((Level)world, null, (BlockPos)pos, (CompatSoundEvent)Sounds.CRASH_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
        }
    }

    public void onBlockBreakStart(BlockBreakStartEvent e) {
        if (e.isClient()) {
            super.onBlockBreakStart(e);
            return;
        }
        net.pitan76.mcpitanlib.api.entity.Player player = e.player;
        if (player.getMainHandStack() == null) {
            super.onBlockBreakStart(e);
            return;
        }
        Item mainHandItem = ItemStackUtil.getItem((ItemStack)player.getMainHandStack());
        if (mainHandItem instanceof SolomonsWand || mainHandItem instanceof DemonsWand) {
            SolomonsWand wand = (SolomonsWand)mainHandItem;
            wand.deleteBlock(e.getWorld(), player, e.getPos());
        }
        super.onBlockBreakStart(e);
    }
}

