/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.solomonsrod;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.result.EventResult;
import net.pitan76.mcpitanlib.api.event.v1.LivingHurtEventRegistry;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.EntityUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemGroups;
import net.pitan76.solomonsrod.Config;
import net.pitan76.solomonsrod.SolomonsRod;
import net.pitan76.solomonsrod.SolomonsWand;
import net.pitan76.solomonsrod.Sounds;

public class DemonsWand
extends SolomonsWand {
    public static DemonsWand DEMONS_WAND = DemonsWand.of(SolomonsRod._id("demons_wand"));

    public DemonsWand(CompatibleItemSettings settings) {
        super(settings);
        LivingHurtEventRegistry.register(e -> {
            if (!e.isPlayerAttacker()) {
                return EventResult.pass();
            }
            LivingEntity entity = e.getEntity();
            Player player = e.getPlayerAttacker();
            ItemStack stack = player.getMainHandStack();
            if (stack == null || !(stack.getItem() instanceof DemonsWand)) {
                return EventResult.pass();
            }
            if (!Config.infiniteDurability && ItemStackUtil.isBreak((ItemStack)stack)) {
                return EventResult.pass();
            }
            if (entity instanceof Animal || entity instanceof Slime || entity instanceof Villager || entity instanceof WaterAnimal) {
                WorldUtil.playSound((Level)player.getWorld(), null, (BlockPos)player.getBlockPos(), (CompatSoundEvent)Sounds.BAM_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
                EntityUtil.kill((Entity)entity);
                SolomonsWand.damageStackIfDamageable(stack, player, InteractionHand.MAIN_HAND);
                return EventResult.success();
            }
            return EventResult.pass();
        });
    }

    public static DemonsWand of(CompatIdentifier id) {
        CompatibleItemSettings settings = CompatibleItemSettings.of((CompatIdentifier)id).addGroup(ItemGroups.TOOLS).enchantable(15);
        if (!Config.infiniteDurability) {
            settings.maxDamage(Config.maxDamage);
        } else {
            settings.maxCount(1);
        }
        return new DemonsWand(settings);
    }
}

