/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.solomonsrod;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.item.EnchantableArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.HandUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemGroups;
import net.pitan76.solomonsrod.Config;
import net.pitan76.solomonsrod.SolomonsBlock;
import net.pitan76.solomonsrod.SolomonsRod;
import net.pitan76.solomonsrod.Sounds;

public class SolomonsWand
extends CompatItem {
    public static SolomonsWand SOLOMONS_WAND = SolomonsWand.of(SolomonsRod._id("solomon_wand"));

    public SolomonsWand(CompatibleItemSettings settings) {
        super(settings);
    }

    public static SolomonsWand of(CompatIdentifier id) {
        CompatibleItemSettings settings = CompatibleItemSettings.of((CompatIdentifier)id).addGroup(ItemGroups.TOOLS).enchantable(15);
        if (!Config.infiniteDurability) {
            settings.maxDamage(Config.maxDamage);
        } else {
            settings.maxCount(1);
        }
        return new SolomonsWand(settings);
    }

    public void deleteBlock(Level world, Player user, BlockPos pos) {
        WorldUtil.removeBlock((Level)world, (BlockPos)pos, (boolean)false);
        WorldUtil.playSound((Level)world, null, (BlockPos)user.getBlockPos(), (CompatSoundEvent)Sounds.ERASE_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
    }

    public CompatActionResult onRightClickOnBlock(ItemUseOnBlockEvent e) {
        Level world = e.world;
        BlockPos blockPos = PosUtil.flooredBlockPos((Vec3)e.getPos());
        if (!Config.infiniteDurability && ItemStackUtil.isBreak((ItemStack)e.stack)) {
            return super.onRightClickOnBlock(e);
        }
        if (e.isClient()) {
            if (WorldUtil.canSetBlock((Level)world, (BlockPos)blockPos) && SolomonsWand.canPlace(WorldUtil.getBlockState((Level)world, (BlockPos)blockPos).getBlock())) {
                return e.success();
            }
            return super.onRightClickOnBlock(e);
        }
        if (!WorldUtil.canSetBlock((Level)world, (BlockPos)blockPos) || !SolomonsWand.canPlace(WorldUtil.getBlockState((Level)world, (BlockPos)blockPos).getBlock())) {
            return super.onRightClickOnBlock(e);
        }
        if (WorldUtil.getBlockEntity((Level)world, (BlockPos)blockPos) != null) {
            WorldUtil.playSound((Level)world, null, (BlockPos)e.player.getBlockPos(), (CompatSoundEvent)Sounds.NOCRASH_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
            return e.success();
        }
        WorldUtil.setBlockState((Level)world, (BlockPos)blockPos, (BlockState)BlockStateUtil.getDefaultState((Block)SolomonsBlock.SOLOMONS_BLOCK));
        WorldUtil.playSound((Level)world, null, (BlockPos)blockPos, (CompatSoundEvent)Sounds.CREATE_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
        SolomonsWand.damageStackIfDamageable(e.player.getStackInHand(e.hand), e.player, e.hand);
        return e.success();
    }

    public StackActionResult onRightClick(ItemUseEvent e) {
        Player user;
        BlockPos blockPos;
        Level world;
        if (!Config.infiniteDurability && ItemStackUtil.isBreak((ItemStack)e.stack)) {
            return super.onRightClick(e);
        }
        if (e.isClient()) {
            super.onRightClick(e);
        }
        if (WorldUtil.canSetBlock((Level)(world = e.world), (BlockPos)(blockPos = SolomonsWand.getPlacingPos(user = e.user))) && SolomonsWand.canPlace(WorldUtil.getBlockState((Level)world, (BlockPos)blockPos).getBlock()) && WorldUtil.getBlockEntity((Level)world, (BlockPos)blockPos) == null) {
            WorldUtil.setBlockState((Level)world, (BlockPos)blockPos, (BlockState)BlockStateUtil.getDefaultState((Block)SolomonsBlock.SOLOMONS_BLOCK));
            WorldUtil.playSound((Level)world, null, (BlockPos)user.getBlockPos(), (CompatSoundEvent)Sounds.CREATE_SOUND, (CompatSoundCategory)CompatSoundCategory.MASTER, (float)1.0f, (float)1.0f);
            SolomonsWand.damageStackIfDamageable(e.stack, user, e.hand);
            return e.success();
        }
        return super.onRightClick(e);
    }

    public static void damageStackIfDamageable(ItemStack stack, Player player, InteractionHand hand) {
        if (!Config.infiniteDurability) {
            Optional optionalServerPlayer = player.getServerPlayer();
            if (!optionalServerPlayer.isPresent()) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)optionalServerPlayer.get();
            ItemStackUtil.damage((ItemStack)stack, (int)1, (LivingEntity)serverPlayer, (EquipmentSlot)HandUtil.getEquipmentSlot((InteractionHand)hand));
        }
    }

    public static BlockPos getPlacingPos(Player user) {
        Vec3 pos = user.getPos();
        double posX = pos.x();
        double posY = pos.y();
        double posZ = pos.z();
        boolean notChange = false;
        if (user.getPitch() <= -25.0f) {
            posY += 2.0;
            if (user.getPitch() <= -60.0f && user.getPitch() >= -90.0f) {
                notChange = true;
            }
        }
        if (user.getPitch() <= 25.0f && user.getPitch() >= -25.0f) {
            posY += 1.0;
        }
        if (user.getPitch() >= 50.0f) {
            posY -= 1.0;
            if (user.getPitch() <= 90.0f && user.getPitch() >= 75.0f) {
                notChange = true;
            }
        }
        if (!notChange) {
            if (user.getHorizontalFacing() == Direction.EAST) {
                posX += 1.0;
            }
            if (user.getHorizontalFacing() == Direction.WEST) {
                posX -= 1.0;
            }
            if (user.getHorizontalFacing() == Direction.NORTH) {
                posZ -= 1.0;
            }
            if (user.getHorizontalFacing() == Direction.SOUTH) {
                posZ += 1.0;
            }
        }
        return PosUtil.flooredBlockPos((double)posX, (double)posY, (double)posZ);
    }

    public static boolean canPlace(Block block) {
        if (block == null) {
            return true;
        }
        if (block instanceof AirBlock) {
            return true;
        }
        if (block instanceof LiquidBlock) {
            return true;
        }
        if (block instanceof TallGrassBlock) {
            return true;
        }
        return block instanceof DeadBushBlock;
    }

    public boolean isEnchantable(EnchantableArgs args) {
        return true;
    }
}

