package com.boyonk.realisticfarmland;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RealisticFarmland implements ModInitializer {

	private static final int SOURCE_MOISTURE = 7;
	private static final int RAIN_MOISTURE = 1;
	private static final int MAX_MOISTURE = 7;
	private static final int[] RADII = {1, 1, 1, 1, 1, 1, 1, 2};

	public static void randomTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		int radius = RADII[state.method_11654(class_2741.field_12510)];
		List<class_2338> offsets = class_156.method_43252(class_2338.method_17962(pos.method_10263() - radius, pos.method_10264() - 1, pos.method_10260() - radius, pos.method_10263() + radius, pos.method_10264() + 1, pos.method_10260() + radius).map(class_2338::method_10062).filter(p -> !p.equals(pos)), random);

		Map<class_2338, Integer> farmland = new LinkedHashMap<>(10);
		farmland.put(pos, state.method_11654(class_2741.field_12510));

		Optional<class_2338> source = Optional.empty();

		for (class_2338 offset : offsets) {
			class_2680 neighbor = world.method_8320(offset);
			if (neighbor.method_27852(class_2246.field_10362)) {
				farmland.put(offset, neighbor.method_11654(class_2741.field_12510));
			} else if (source.isEmpty() && ((radius == 1) || ((Math.abs(offset.method_10263() - pos.method_10263()) <= 1) && (Math.abs(offset.method_10260() - pos.method_10260()) <= 1)))) {
				class_3610 fluid = neighbor.method_26227();
				if (!fluid.method_15767(class_3486.field_15517)) continue;
				if (!fluid.method_15771()) continue;
				if (!(neighbor.method_26204() instanceof class_2263)) continue;
				source = Optional.of(offset);
			}
		}

		int total = farmland.values().stream().mapToInt(Integer::intValue).sum();
		boolean totalChange = false;
		boolean invert = false;
		if (source.isPresent() && (total + SOURCE_MOISTURE) <= farmland.size() * MAX_MOISTURE) {
			class_2680 sourceState = world.method_8320(source.get());
			if (!((class_2263) sourceState.method_26204()).method_9700(null, world, source.get(), sourceState).method_7960()) {
				total += SOURCE_MOISTURE;
				totalChange = true;
			}
		}
		if (!totalChange && world.method_8520(pos.method_10084())) {
			total += RAIN_MOISTURE;
			totalChange = true;
		}

		if (!totalChange && !class_2344.method_10124(world, pos)) {
			total--;
			invert = true;
			totalChange = true;
		}

		int floor;
		int remainder;
		if (invert) {
			floor = class_3532.method_38788(total, farmland.size());
			remainder = total - (floor * farmland.size());
		} else {
			floor = class_3532.method_48116(total, farmland.size());
			if (!totalChange) {
				int min = farmland.values().stream().mapToInt(Integer::intValue).min().orElse(0);
				if (floor <= min) return;
			}
			remainder = total - (floor * farmland.size());
		}

		for (class_2338 farmlandPos : farmland.keySet()) {
			int moisture = floor + (invert ? remainder++ < 0 ? -1 : 0 : remainder-- > 0 ? 1 : 0);
			if (moisture >= 0) {
				world.method_8501(farmlandPos, class_2246.field_10362.method_9564().method_11657(class_2741.field_12510, Math.min(moisture, MAX_MOISTURE)));
			} else {
				class_2344.method_10125(null, world.method_8320(farmlandPos), world, farmlandPos);
			}
		}

	}


	@Override
	public void onInitialize() {
		UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
			if (player.method_7325()) return class_1269.field_5811;

			class_1799 stack = player.method_5998(hand);
			if (!stack.method_31574(class_1802.field_8705)) return class_1269.field_5811;

			class_2338 pos = world.method_8320(hitResult.method_17777()).method_26164(class_3481.field_20341) ? hitResult.method_17777().method_10074() : hitResult.method_17777();
			class_2680 state = world.method_8320(pos);
			if (!state.method_27852(class_2246.field_10362)) return class_1269.field_5811;

			if (world.method_8608()) return class_1269.field_5812;

			class_1792 item = stack.method_7909();
			player.method_6122(hand, class_5328.method_30012(stack, player, new class_1799(class_1802.field_8550)));
			player.method_7259(class_3468.field_15372.method_14956(item));
			world.method_8501(pos, state);
			world.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
			world.method_33596(null, class_5712.field_28166, pos);

			int radius = 2;
			List<class_2338> offsets = class_156.method_43252(class_2338.method_17962(pos.method_10263() - radius, pos.method_10264() - 1, pos.method_10260() - radius, pos.method_10263() + radius, pos.method_10264() + 1, pos.method_10260() + radius).map(class_2338::method_10062).filter(p -> !p.equals(pos)), player.method_59922());

			Map<class_2338, Integer> farmland = new LinkedHashMap<>(5);
			farmland.put(pos, state.method_11654(class_2741.field_12510));

			for (class_2338 offset : offsets) {
				class_2680 neighbor = world.method_8320(offset);
				if (neighbor.method_27852(class_2246.field_10362)) {
					farmland.put(offset, neighbor.method_11654(class_2741.field_12510));
				}
			}

			int total = farmland.values().stream().mapToInt(Integer::intValue).sum() + SOURCE_MOISTURE;
			int floor = total / farmland.size();
			int remainder = total - (floor * farmland.size());
			for (class_2338 farmlandPos : farmland.keySet()) {
				world.method_8501(farmlandPos, class_2246.field_10362.method_9564().method_11657(class_2741.field_12510, Math.min(MAX_MOISTURE, floor + (remainder-- > 0 ? 1 : 0))));
			}

			return class_1269.field_5812;
		});

	}

}
