/*
 * Decompiled with CFR 0.152.
 */
package com.starfruit.nextannouncers;

import com.google.inject.Inject;
import com.starfruit.nextannouncers.announcers.AnnouncersManager;
import com.starfruit.nextannouncers.command.MainCommands;
import com.starfruit.nextannouncers.config.ConfigManager;
import com.starfruit.nextannouncers.config.LangManager;
import com.starfruit.nextannouncers.task.AnnouncersTask;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.logging.Logger;

@Plugin(id="nextannouncers", name="NextAnnouncers", authors={"Starfruit"}, description="NextAnnouncers, a plugin that can send announcers to your players anywhere!", url="https://github.com/Starfruit2210", version="1.0.0")
public class NextAnnouncers {
    public static NextAnnouncers instance;
    private final ProxyServer server;
    private final Path directoryPath;
    private final Logger logger;
    private ConfigManager configManager;
    private LangManager langManager;
    private AnnouncersManager announcersManager;
    private AnnouncersTask announcersTask;

    @Inject
    public NextAnnouncers(ProxyServer server, @DataDirectory Path directoryPath, Logger logger) {
        instance = this;
        this.server = server;
        this.directoryPath = directoryPath;
        this.logger = logger;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.configManager = new ConfigManager(this);
        this.langManager = new LangManager(this);
        this.announcersManager = new AnnouncersManager(this, this.logger);
        this.announcersManager.load();
        this.announcersTask = new AnnouncersTask(this);
        this.announcersTask.start();
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta meta = commandManager.metaBuilder("nextannouncers").plugin((Object)this).aliases(new String[]{"announcers", "announcer", "nannouncers", "nannouncer"}).build();
        commandManager.register(meta, (Command)MainCommands.register(this));
    }

    public static NextAnnouncers getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.directoryPath;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LangManager getLangManager() {
        return this.langManager;
    }

    public AnnouncersManager getAnnouncersManager() {
        return this.announcersManager;
    }

    public AnnouncersTask getAnnouncersTask() {
        return this.announcersTask;
    }
}

