/*
 * Decompiled with CFR 0.152.
 */
package com.starfruit.nextannouncers.Utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public final class ColorUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("&\\#([0-9a-fA-F]{6})");
    private static final Pattern URL_PATTERN = Pattern.compile("(?i)((?:https?://|www\\.)\\S+)");
    private static final Pattern STYLE_SCAN = Pattern.compile("&\\#([0-9a-fA-F]{6})|&([0-9a-fA-Fk-orK-OR])");
    private static final Pattern COLOR_SCAN = Pattern.compile("&\\#([0-9a-fA-F]{6})|&([0-9a-fA-Fk-orK-OR])");
    private static final LegacyComponentSerializer SECTION_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    private ColorUtils() {
    }

    public static Component toComponent(String input) {
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        String withSectionHex = ColorUtils.replaceAmpersandHashHexWithSectionHex(input);
        String withSectionCodes = withSectionHex.replaceAll("&([0-9a-fk-orA-FK-OR])", "\u00a7$1");
        return SECTION_SERIALIZER.deserialize(withSectionCodes);
    }

    public static Component toComponentWithLinks(String input) {
        if (input == null || input.isBlank()) {
            return Component.empty();
        }
        Matcher m = URL_PATTERN.matcher(input);
        int last = 0;
        TextComponent out = Component.empty();
        while (m.find()) {
            String before = input.substring(last, m.start());
            if (!before.isEmpty()) {
                out = out.append(ColorUtils.toComponent(before));
            }
            Style carry = ColorUtils.lastActiveStyle(before);
            String rawUrl = m.group(1);
            Object openUrl = rawUrl.startsWith("http") ? rawUrl : "https://" + rawUrl;
            Component link = Component.text((String)rawUrl).style(carry);
            link = link.clickEvent(ClickEvent.openUrl((String)openUrl)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Open " + (String)openUrl))));
            out = out.append(link);
            last = m.end();
        }
        String tail = input.substring(last);
        if (!tail.isEmpty()) {
            out = out.append(ColorUtils.toComponent(tail));
        }
        return out;
    }

    public static List<Component> toComponentListWithLinks(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> out = new ArrayList<Component>(lines.size());
        for (String line : lines) {
            out.add(ColorUtils.toComponentWithLinks(line));
        }
        return out;
    }

    public static Component joinLines(List<Component> lines) {
        TextComponent result = Component.empty();
        for (int i = 0; i < lines.size(); ++i) {
            result = result.append(lines.get(i));
            if (i >= lines.size() - 1) continue;
            result = result.append((Component)Component.newline());
        }
        return result;
    }

    private static String replaceAmpersandHashHexWithSectionHex(String input) {
        Matcher m = HEX_PATTERN.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String hex = m.group(1);
            m.appendReplacement(sb, Matcher.quoteReplacement(ColorUtils.toSectionHex(hex)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String toSectionHex(String hex6) {
        String h = hex6.toLowerCase();
        if (h.length() != 6) {
            return "\u00a7r";
        }
        char r1 = h.charAt(0);
        char r2 = h.charAt(1);
        char g1 = h.charAt(2);
        char g2 = h.charAt(3);
        char b1 = h.charAt(4);
        char b2 = h.charAt(5);
        return new StringBuilder(14).append('\u00a7').append('x').append('\u00a7').append(r1).append('\u00a7').append(r2).append('\u00a7').append(g1).append('\u00a7').append(g2).append('\u00a7').append(b1).append('\u00a7').append(b2).toString();
    }

    private static Style lastActiveStyle(String s) {
        if (s == null || s.isEmpty()) {
            return Style.empty();
        }
        Matcher m = STYLE_SCAN.matcher(s);
        TextColor color = null;
        boolean obf = false;
        boolean bold = false;
        boolean strike = false;
        boolean under = false;
        boolean italic = false;
        while (m.find()) {
            String hex = m.group(1);
            String code = m.group(2);
            if (hex != null) {
                try {
                    color = TextColor.fromHexString((String)("#" + hex));
                }
                catch (Exception exception) {}
                continue;
            }
            if (code == null) continue;
            char c = Character.toLowerCase(code.charAt(0));
            switch (c) {
                case '0': {
                    color = NamedTextColor.BLACK;
                    break;
                }
                case '1': {
                    color = NamedTextColor.DARK_BLUE;
                    break;
                }
                case '2': {
                    color = NamedTextColor.DARK_GREEN;
                    break;
                }
                case '3': {
                    color = NamedTextColor.DARK_AQUA;
                    break;
                }
                case '4': {
                    color = NamedTextColor.DARK_RED;
                    break;
                }
                case '5': {
                    color = NamedTextColor.DARK_PURPLE;
                    break;
                }
                case '6': {
                    color = NamedTextColor.GOLD;
                    break;
                }
                case '7': {
                    color = NamedTextColor.GRAY;
                    break;
                }
                case '8': {
                    color = NamedTextColor.DARK_GRAY;
                    break;
                }
                case '9': {
                    color = NamedTextColor.BLUE;
                    break;
                }
                case 'a': {
                    color = NamedTextColor.GREEN;
                    break;
                }
                case 'b': {
                    color = NamedTextColor.AQUA;
                    break;
                }
                case 'c': {
                    color = NamedTextColor.RED;
                    break;
                }
                case 'd': {
                    color = NamedTextColor.LIGHT_PURPLE;
                    break;
                }
                case 'e': {
                    color = NamedTextColor.YELLOW;
                    break;
                }
                case 'f': {
                    color = NamedTextColor.WHITE;
                    break;
                }
                case 'k': {
                    obf = true;
                    break;
                }
                case 'l': {
                    bold = true;
                    break;
                }
                case 'm': {
                    strike = true;
                    break;
                }
                case 'n': {
                    under = true;
                    break;
                }
                case 'o': {
                    italic = true;
                    break;
                }
                case 'r': {
                    color = null;
                    italic = false;
                    under = false;
                    strike = false;
                    bold = false;
                    obf = false;
                }
            }
        }
        Style style = Style.empty();
        if (color != null) {
            style = style.color(color);
        }
        if (obf) {
            style = style.decoration(TextDecoration.OBFUSCATED, TextDecoration.State.TRUE);
        }
        if (bold) {
            style = style.decoration(TextDecoration.BOLD, TextDecoration.State.TRUE);
        }
        if (strike) {
            style = style.decoration(TextDecoration.STRIKETHROUGH, TextDecoration.State.TRUE);
        }
        if (under) {
            style = style.decoration(TextDecoration.UNDERLINED, TextDecoration.State.TRUE);
        }
        if (italic) {
            style = style.decoration(TextDecoration.ITALIC, TextDecoration.State.TRUE);
        }
        return style;
    }

    private static TextColor lastActiveColor(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        Matcher m = COLOR_SCAN.matcher(s);
        TextColor last = null;
        while (m.find()) {
            String hex = m.group(1);
            String code = m.group(2);
            if (hex != null) {
                try {
                    last = TextColor.fromHexString((String)("#" + hex));
                }
                catch (Exception exception) {}
                continue;
            }
            if (code == null) continue;
            char c = Character.toLowerCase(code.charAt(0));
            if (c == 'r') {
                last = null;
                continue;
            }
            TextColor mapped = ColorUtils.mapLegacyColor(c);
            if (mapped == null) continue;
            last = mapped;
        }
        return last;
    }

    private static TextColor mapLegacyColor(char c) {
        return switch (c) {
            case '0' -> NamedTextColor.BLACK;
            case '1' -> NamedTextColor.DARK_BLUE;
            case '2' -> NamedTextColor.DARK_GREEN;
            case '3' -> NamedTextColor.DARK_AQUA;
            case '4' -> NamedTextColor.DARK_RED;
            case '5' -> NamedTextColor.DARK_PURPLE;
            case '6' -> NamedTextColor.GOLD;
            case '7' -> NamedTextColor.GRAY;
            case '8' -> NamedTextColor.DARK_GRAY;
            case '9' -> NamedTextColor.BLUE;
            case 'a' -> NamedTextColor.GREEN;
            case 'b' -> NamedTextColor.AQUA;
            case 'c' -> NamedTextColor.RED;
            case 'd' -> NamedTextColor.LIGHT_PURPLE;
            case 'e' -> NamedTextColor.YELLOW;
            case 'f' -> NamedTextColor.WHITE;
            default -> null;
        };
    }
}

