/*
 * Decompiled with CFR 0.152.
 */
package com.starfruit.nextannouncers.announcers;

import com.starfruit.nextannouncers.NextAnnouncers;
import com.starfruit.nextannouncers.announcers.Announcers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public record AnnouncersManager(NextAnnouncers plugin, Logger logger) {
    private static final Map<Integer, Announcers> announcers = new ConcurrentHashMap<Integer, Announcers>();

    public Map<Integer, Announcers> getAnnouncers() {
        return announcers;
    }

    public static void addAnnouncers(Announcers announcers) {
        AnnouncersManager.announcers.put(announcers.getId(), announcers);
    }

    public static void removeAnnouncers(int id) {
        announcers.remove(id);
    }

    public Announcers getAnnouncers(int id) {
        return announcers.get(id);
    }

    public boolean announcersExists(int id) {
        return announcers.containsKey(id);
    }

    public static void clearAnnouncers() {
        announcers.clear();
    }

    public void load() {
        AnnouncersManager.clearAnnouncers();
        for (String key : this.plugin.getConfigManager().getConfiguration().getSection("announcers").getKeys().stream().map(Object::toString).collect(Collectors.toSet())) {
            List<String> messages = this.plugin.getConfigManager().getConfiguration().getStringList("announcers." + key + ".messages");
            List<String> sounds = this.plugin.getConfigManager().getConfiguration().getStringList("announcers." + key + ".sounds");
            AnnouncersManager.addAnnouncers(new Announcers(Integer.parseInt(key), messages, sounds));
            this.logger.info("Loaded announcers " + key);
        }
    }
}

