/*
 * Decompiled with CFR 0.152.
 */
package com.starfruit.nextannouncers.config;

import com.starfruit.nextannouncers.NextAnnouncers;
import com.starfruit.nextannouncers.libs.boostedyaml.YamlDocument;
import com.starfruit.nextannouncers.libs.boostedyaml.settings.dumper.DumperSettings;
import com.starfruit.nextannouncers.libs.boostedyaml.settings.general.GeneralSettings;
import com.starfruit.nextannouncers.libs.boostedyaml.settings.loader.LoaderSettings;
import com.starfruit.nextannouncers.libs.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class LangManager {
    private final NextAnnouncers plugin;
    private YamlDocument config;

    public LangManager(NextAnnouncers plugin) {
        this.plugin = plugin;
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadConfig() throws IOException {
        try {
            this.config = YamlDocument.create(new File(this.plugin.getDataDirectory().toFile(), "lang.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/lang.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build());
            this.config.update();
            this.config.save();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create/load plugin language file! The plugin will shutdown...");
            this.plugin.getServer().getPluginManager().getPlugin("nextannouncers").ifPresent(pluginContainer -> pluginContainer.getExecutorService().shutdown());
            throw new RuntimeException(e);
        }
    }

    public void reloadConfig() throws IOException {
        this.config.reload();
        this.config.save();
    }

    public void saveConfig() {
        try {
            this.config.save();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Cannot save the language file! There might be a problem with the lang file.");
            e.printStackTrace();
        }
    }

    public YamlDocument getConfiguration() {
        return this.config;
    }
}

