/*
 * Decompiled with CFR 0.152.
 */
package com.starfruit.nextannouncers.task;

import com.starfruit.nextannouncers.NextAnnouncers;
import com.starfruit.nextannouncers.Utils.ColorUtils;
import com.starfruit.nextannouncers.announcers.Announcers;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;

public class AnnouncersTask {
    private final NextAnnouncers plugin;
    private ScheduledTask task;
    private List<Announcers> announcersList = new ArrayList<Announcers>();
    private int index = 0;
    private long tickCounter = 0L;

    public AnnouncersTask(NextAnnouncers plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.stop();
        if (!this.plugin.getConfigManager().getConfiguration().getBoolean("announcers-enabled").booleanValue()) {
            return;
        }
        Map<Integer, Announcers> map = this.plugin.getAnnouncersManager().getAnnouncers();
        List<String> blacklistServers = this.plugin.getConfigManager().getConfiguration().getStringList("blacklist-servers");
        Set blacklistServersSet = blacklistServers.stream().filter(Objects::nonNull).map(s -> s.trim().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        this.announcersList = map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).toList();
        this.index = 0;
        this.tickCounter = 0L;
        this.task = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            if (this.announcersList.isEmpty()) {
                return;
            }
            Announcers current = this.announcersList.get(this.index);
            this.index = (this.index + 1) % this.announcersList.size();
            ++this.tickCounter;
            List<Component> messages = current.getMessages() != null ? current.getMessages().stream().map(ColorUtils::toComponentWithLinks).toList() : List.of();
            Component joined = ColorUtils.joinLines(messages);
            Sound soundToPlay = null;
            List<String> sounds = current.getSounds();
            if (sounds != null && !sounds.isEmpty()) {
                String raw = sounds.get((int)(this.tickCounter % (long)sounds.size())).trim();
                String[] split = raw.split(";", 3);
                String id = split[0].trim();
                float vol = split.length >= 2 ? AnnouncersTask.parseOrDefault(split[1], 1.0f) : 1.0f;
                float pit = split.length >= 3 ? AnnouncersTask.parseOrDefault(split[2], 1.0f) : 1.0f;
                try {
                    soundToPlay = Sound.sound((Key)Key.key((String)id), (Sound.Source)Sound.Source.MASTER, (float)vol, (float)pit);
                }
                catch (Exception ignored) {
                    this.plugin.getLogger().warning("Invalid sound id: " + id);
                }
            }
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                boolean isBlacklisted = player.getCurrentServer().map(conn -> conn.getServerInfo().getName()).map(name -> name.toLowerCase(Locale.ROOT)).map(blacklistServersSet::contains).orElse(false);
                if (isBlacklisted) continue;
                if (soundToPlay != null) {
                    player.playSound(soundToPlay, Sound.Emitter.self());
                }
                player.sendMessage(joined);
            }
        }).delay(2L, TimeUnit.SECONDS).repeat((long)this.plugin.getConfigManager().getConfiguration().getInt("announcer-interval").intValue(), TimeUnit.SECONDS).schedule();
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private static float parseOrDefault(String s, float def) {
        try {
            return Float.parseFloat(s.trim());
        }
        catch (Exception e) {
            return def;
        }
    }
}

