/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import java.util.List;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.thruster.AbstractThrusterBlockEntity;
import net.jcm.vsch.blocks.thruster.ThrusterEngine;
import net.jcm.vsch.blocks.thruster.ThrusterEngineContext;
import net.lointain.cosmos.init.CosmosModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CreativeThrusterBlockEntity
extends AbstractThrusterBlockEntity {
    private int maxThrottle = 500000;

    public CreativeThrusterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.CREATIVE_THRUSTER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected String getPeripheralType() {
        return "creative_thruster";
    }

    @Override
    protected ThrusterEngine createThrusterEngine() {
        return new CreativeThrusterEngine();
    }

    @Override
    protected ParticleOptions getThrusterParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.AIR_THRUST.get();
    }

    @Override
    protected ParticleOptions getThrusterSmokeParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.AIR_THRUST.get();
    }

    @Override
    protected double getEvaporateDistance() {
        return 0.0;
    }

    @Override
    protected void spawnParticles(Vector3d pos, Vector3d direction) {
        Vector3d speed = new Vector3d((Vector3dc)direction).mul(this.getCurrentPower());
        speed.mul(0.118);
        int amount = 100;
        for (int i = 0; i < amount; ++i) {
            this.f_58857_.m_7106_(this.getThrusterParticleType(), pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
    }

    @Override
    public InteractionResult onUseWrench(UseOnContext ctx) {
        if (ctx.m_43723_().m_6144_()) {
            this.maxThrottle += 100000;
            if (this.maxThrottle > 500000) {
                this.maxThrottle = 100000;
            }
            return InteractionResult.SUCCESS;
        }
        return super.onUseWrench(ctx);
    }

    @Override
    public void onFocusWithWrench(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_ && player.m_6144_()) {
            player.m_5661_((Component)Component.m_237113_((String)"Max Throttle: ").m_7220_((Component)Component.m_237113_((String)String.format("%dN", this.maxThrottle))), true);
        }
        super.onFocusWithWrench(stack, level, player);
    }

    private final class CreativeThrusterEngine
    extends ThrusterEngine {
        public CreativeThrusterEngine() {
            super(0, 0, 0.0f);
        }

        @Override
        public float getMaxThrottle() {
            return CreativeThrusterBlockEntity.this.maxThrottle;
        }

        @Override
        public boolean isValidFuel(int tank, Fluid fluid) {
            return false;
        }

        @Override
        public void tick(ThrusterEngineContext context) {
            super.tick(context);
            double power = context.getPower();
            if (power == 0.0) {
                return;
            }
        }

        @Override
        public void tickBurningObjects(ThrusterEngineContext context, List<BlockPos> thrusters, Direction direction) {
        }
    }
}

