/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import java.util.List;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.jcm.vsch.config.VSCHServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class GravityInducerBlockEntity
extends BlockEntity
implements ParticleBlockEntity {
    private static final double MIN_FORCE = 0.01;

    public GravityInducerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)VSCHBlockEntities.GRAVITY_INDUCER_BLOCK_ENTITY.get(), pos, blockState);
    }

    public double getAttractDistance() {
        return ((Number)VSCHServerConfig.GRAVITY_DISTANCE.get()).doubleValue();
    }

    public double getMaxForce() {
        return ((Number)VSCHServerConfig.GRAVITY_MAX_FORCE.get()).doubleValue();
    }

    @Override
    public void tickForce(ServerLevel level, BlockPos pos, BlockState state) {
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)pos);
        if (ship == null) {
            return;
        }
        List entities = level.m_45933_(null, VectorConversionsMCKt.toMinecraft((AABBdc)ship.getWorldAABB()));
        for (Entity entity : entities) {
            if (entity.f_19794_) continue;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.m_150110_().f_35935_) continue;
            }
            double maxDistance = this.getAttractDistance();
            Vec3 direction = new Vec3(0.0, -1.0, 0.0);
            Vec3 startPos = entity.m_20182_();
            Vec3 endPos = startPos.m_82549_(direction.m_82490_(maxDistance));
            BlockHitResult hitResult = level.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
            double distance = startPos.m_82557_(hitResult.m_82450_());
            double scaledForce = Math.min(maxDistance * maxDistance / distance * 0.01, this.getMaxForce());
            Vec3 force = direction.m_82490_(scaledForce);
            entity.m_5997_(force.f_82479_, force.f_82480_, force.f_82481_);
        }
    }

    @Override
    public void tickParticles(Level level, BlockPos pos, BlockState state) {
    }
}

